<?php

if ( ! function_exists( 'bridge_qode_get_module_part' ) ) {
    function bridge_qode_get_module_part( $module ) {
        return $module;
    }
}

if( ! function_exists( 'bridge_qode_get_blog_query_posts' ) ){
    function bridge_qode_get_blog_query_posts( $qode_template_name = null ){

        global $wp_query;

        $bridge_qode_id = bridge_qode_get_page_id();
        $bridge_qode_category = get_post_meta($bridge_qode_id, "qode_choose-blog-category", true);
        $bridge_qode_post_number = get_post_meta($bridge_qode_id, "qode_show-posts-per-page", true);
        if ( get_query_var('paged') ) {
            $bridge_qode_paged = get_query_var('paged');
        } elseif ( get_query_var('page') ) {
            $bridge_qode_paged = get_query_var('page');
        }
        else {
            $bridge_qode_paged = 1;
        }

        $query_array = array(
            'post_status'    => 'publish',
            'post_type'      => 'post',
            'paged'          => $bridge_qode_paged,
            'cat'            => $bridge_qode_category,
            'posts_per_page' => $bridge_qode_post_number
        );

        if( $qode_template_name == 'blog-compound.php' ){
            $query_array['post__not_in'] = get_option('sticky_posts');
        }

        if( $qode_template_name == 'blog-vertical-loop.php' ){
            $query_array['posts_per_page'] = 1;
        }

        $blog_query = new WP_Query( $query_array );
        if ( is_archive() ) {
            global $wp_query;
            $blog_query = $wp_query;
        }

        return $blog_query;
    }
}

if ( ! function_exists( 'bridge_qode_return_global_options' ) ) {
    function bridge_qode_return_global_options() {
        global $qode_options_proya;

        return $qode_options_proya;
    }
}

if ( ! function_exists( 'bridge_qode_return_global_query' ) ) {
    function bridge_qode_return_global_query() {
        global $wp_query;

        return $wp_query;
    }
}

if ( ! function_exists( 'bridge_qode_return_icon_collections' ) ) {
    function bridge_qode_return_icon_collections() {
        global $qodeIconCollections;

        return $qodeIconCollections;
    }
}

if ( ! function_exists( 'bridge_qode_return_template_name' ) ) {
    function bridge_qode_return_template_name() {
        global $qode_template_name;

        return $qode_template_name;
    }
}

if ( ! function_exists( 'bridge_qode_return_wp_filesystem' ) ) {
    function bridge_qode_return_wp_filesystem() {
        global $wp_filesystem;

        return $wp_filesystem;
    }
}

if ( ! function_exists( 'bridge_qode_wp_link_pages' ) ) {
    function bridge_qode_wp_link_pages() {
        $args_pages = array(
            'before'   => '<p class="single_links_pages">',
            'after'    => '</p>',
            'pagelink' => '<span>%</span>'
        );

        wp_link_pages( $args_pages );
    }
}

if ( ! function_exists( 'bridge_qode_wp_link_pages_exist' ) ) {
    function bridge_qode_wp_link_pages_exist() {
        $args_pages = array(
            'echo' => 0
        );

        return wp_link_pages( $args_pages );
    }
}

if ( ! function_exists( 'bridge_qode_init_global_option' ) ) {
	function bridge_qode_init_global_option() {

		if ( ! bridge_qode_qode_core_installed() ) {
			global $qode_options_proya;

			$qode_options_proya = array(
				  'enable_grid_elements' => 'no',
				  'disable_google_fonts' => 'no',
				  'google_fonts' => '-1',
				  'additional_google_fonts' => 'no',
				  'additional_google_font1' => '-1',
				  'additional_google_font2' => '-1',
				  'additional_google_font3' => '-1',
				  'additional_google_font4' => '-1',
				  'additional_google_font5' => '-1',
				  'qode_custom_fonts' => '',
				  'first_color' => '',
				  'second_color' => '',
				  'third_color' => '',
				  'fourth_color' => '',
				  'background_color' => '',
				  'background_color_boxes' => '',
				  'selection_color' => '',
				  'gradient_style1_start_color' => '#31c8a2',
				  'gradient_style1_end_color' => '#ae66fd',
				  'transparent_content' => 'no',
				  'transparent_content_background_color' => '',
				  'transparent_content_background_image' => '',
				  'transparent_content_pattern_background_image' => '',
				  'overlapping_content' => 'no',
				  'overlapping_content_amount' => '',
				  'overlapping_content_padding' => '',
				  'boxed' => 'no',
				  'background_color_box' => '',
				  'background_image' => '',
				  'pattern_background_image' => '',
				  'paspartu' => 'no',
				  'paspartu_color' => '',
				  'paspartu_width' => '',
				  'paspartu_header_alignment' => 'no',
				  'paspartu_header_inside' => 'no',
				  'vertical_menu_inside_paspartu' => 'yes',
				  'paspartu_footer_alignment' => 'no',
				  'paspartu_on_top' => 'yes',
				  'paspartu_on_top_fixed' => 'no',
				  'paspartu_on_bottom_slider' => 'no',
				  'paspartu_on_bottom' => 'yes',
				  'paspartu_on_bottom_fixed' => 'no',
				  'enable_content_top_margin' => 'no',
				  'initial_content_width' => 'grid_1100',
				  'content_grid_lines' => 'none',
				  'content_grid_lines_skin' => '',
				  'qode_ui_scripts_option' =>
				  array (
					0 => 'jquery-ui-core',
					1 => 'jquery-ui-widget',
					2 => 'jquery-ui-accordion',
					3 => 'jquery-ui-autocomplete',
					4 => 'jquery-ui-button',
					5 => 'jquery-ui-datepicker',
					6 => 'jquery-ui-dialog',
					7 => 'jquery-ui-draggable',
					8 => 'jquery-ui-droppable',
					9 => 'jquery-ui-menu',
					10 => 'jquery-ui-mouse',
					11 => 'jquery-ui-position',
					12 => 'jquery-ui-progressbar',
					13 => 'jquery-ui-selectable',
					14 => 'jquery-ui-resizable',
					15 => 'jquery-ui-sortable',
					16 => 'jquery-ui-slider',
					17 => 'jquery-ui-spinner',
					18 => 'jquery-ui-tooltip',
					19 => 'jquery-ui-tabs',
					20 => 'jquery-effects-core',
					21 => 'jquery-effects-blind',
					22 => 'jquery-effects-bounce',
					23 => 'jquery-effects-clip',
					24 => 'jquery-effects-drop',
					25 => 'jquery-effects-explode',
					26 => 'jquery-effects-fade',
					27 => 'jquery-effects-fold',
					28 => 'jquery-effects-highlight',
					29 => 'jquery-effects-pulsate',
					30 => 'jquery-effects-scale',
					31 => 'jquery-effects-shake',
					32 => 'jquery-effects-slide',
					33 => 'jquery-effects-transfer',
					34 => 'jquery-ui-core',
					35 => 'jquery-ui-widget',
					36 => 'jquery-ui-accordion',
					37 => 'jquery-ui-autocomplete',
					38 => 'jquery-ui-button',
					39 => 'jquery-ui-datepicker',
					40 => 'jquery-ui-dialog',
					41 => 'jquery-ui-draggable',
					42 => 'jquery-ui-droppable',
					43 => 'jquery-ui-menu',
					44 => 'jquery-ui-mouse',
					45 => 'jquery-ui-position',
					46 => 'jquery-ui-progressbar',
					47 => 'jquery-ui-selectable',
					48 => 'jquery-ui-resizable',
					49 => 'jquery-ui-sortable',
					50 => 'jquery-ui-slider',
					51 => 'jquery-ui-spinner',
					52 => 'jquery-ui-tooltip',
					53 => 'jquery-ui-tabs',
					54 => 'jquery-effects-core',
					55 => 'jquery-effects-blind',
					56 => 'jquery-effects-bounce',
					57 => 'jquery-effects-clip',
					58 => 'jquery-effects-drop',
					59 => 'jquery-effects-explode',
					60 => 'jquery-effects-fade',
					61 => 'jquery-effects-fold',
					62 => 'jquery-effects-highlight',
					63 => 'jquery-effects-pulsate',
					64 => 'jquery-effects-scale',
					65 => 'jquery-effects-shake',
					66 => 'jquery-effects-slide',
					67 => 'jquery-effects-transfer',
					68 => 'jquery-ui-core',
					69 => 'jquery-ui-widget',
					70 => 'jquery-ui-accordion',
					71 => 'jquery-ui-autocomplete',
					72 => 'jquery-ui-button',
					73 => 'jquery-ui-datepicker',
					74 => 'jquery-ui-dialog',
					75 => 'jquery-ui-draggable',
					76 => 'jquery-ui-droppable',
					77 => 'jquery-ui-menu',
					78 => 'jquery-ui-mouse',
					79 => 'jquery-ui-position',
					80 => 'jquery-ui-progressbar',
					81 => 'jquery-ui-selectable',
					82 => 'jquery-ui-resizable',
					83 => 'jquery-ui-sortable',
					84 => 'jquery-ui-slider',
					85 => 'jquery-ui-spinner',
					86 => 'jquery-ui-tooltip',
					87 => 'jquery-ui-tabs',
					88 => 'jquery-effects-core',
					89 => 'jquery-effects-blind',
					90 => 'jquery-effects-bounce',
					91 => 'jquery-effects-clip',
					92 => 'jquery-effects-drop',
					93 => 'jquery-effects-explode',
					94 => 'jquery-effects-fade',
					95 => 'jquery-effects-fold',
					96 => 'jquery-effects-highlight',
					97 => 'jquery-effects-pulsate',
					98 => 'jquery-effects-scale',
					99 => 'jquery-effects-shake',
					100 => 'jquery-effects-slide',
					101 => 'jquery-effects-transfer',
					102 => 'jquery-ui-core',
					103 => 'jquery-ui-widget',
					104 => 'jquery-ui-accordion',
					105 => 'jquery-ui-autocomplete',
					106 => 'jquery-ui-button',
					107 => 'jquery-ui-datepicker',
					108 => 'jquery-ui-dialog',
					109 => 'jquery-ui-draggable',
					110 => 'jquery-ui-droppable',
					111 => 'jquery-ui-menu',
					112 => 'jquery-ui-mouse',
					113 => 'jquery-ui-position',
					114 => 'jquery-ui-progressbar',
					115 => 'jquery-ui-selectable',
					116 => 'jquery-ui-resizable',
					117 => 'jquery-ui-sortable',
					118 => 'jquery-ui-slider',
					119 => 'jquery-ui-spinner',
					120 => 'jquery-ui-tooltip',
					121 => 'jquery-ui-tabs',
					122 => 'jquery-effects-core',
					123 => 'jquery-effects-blind',
					124 => 'jquery-effects-bounce',
					125 => 'jquery-effects-clip',
					126 => 'jquery-effects-drop',
					127 => 'jquery-effects-explode',
					128 => 'jquery-effects-fade',
					129 => 'jquery-effects-fold',
					130 => 'jquery-effects-highlight',
					131 => 'jquery-effects-pulsate',
					132 => 'jquery-effects-scale',
					133 => 'jquery-effects-shake',
					134 => 'jquery-effects-slide',
					135 => 'jquery-effects-transfer',
					136 => 'jquery-ui-core',
					137 => 'jquery-ui-widget',
					138 => 'jquery-ui-accordion',
					139 => 'jquery-ui-autocomplete',
					140 => 'jquery-ui-button',
					141 => 'jquery-ui-datepicker',
					142 => 'jquery-ui-dialog',
					143 => 'jquery-ui-draggable',
					144 => 'jquery-ui-droppable',
					145 => 'jquery-ui-menu',
					146 => 'jquery-ui-mouse',
					147 => 'jquery-ui-position',
					148 => 'jquery-ui-progressbar',
					149 => 'jquery-ui-selectable',
					150 => 'jquery-ui-resizable',
					151 => 'jquery-ui-sortable',
					152 => 'jquery-ui-slider',
					153 => 'jquery-ui-spinner',
					154 => 'jquery-ui-tooltip',
					155 => 'jquery-ui-tabs',
					156 => 'jquery-effects-core',
					157 => 'jquery-effects-blind',
					158 => 'jquery-effects-bounce',
					159 => 'jquery-effects-clip',
					160 => 'jquery-effects-drop',
					161 => 'jquery-effects-explode',
					162 => 'jquery-effects-fade',
					163 => 'jquery-effects-fold',
					164 => 'jquery-effects-highlight',
					165 => 'jquery-effects-pulsate',
					166 => 'jquery-effects-scale',
					167 => 'jquery-effects-shake',
					168 => 'jquery-effects-slide',
					169 => 'jquery-effects-transfer',
				  ),
				  'page_transitions' => '0',
				  'ajax_animate_header' => 'no',
				  'page_loading_effect' => 'no',
				  'loading_animation' => 'off',
				  'loading_animation_spinner' => 'pulse',
				  'spinner_color' => '',
				  'loading_background_color' => '',
				  'loading_image' => '',
				  'loading_animation_left_menu_alignment' => 'no',
				  'smooth_scroll' => 'yes',
				  'elements_animation_on_touch' => 'no',
				  'show_back_button' => 'yes',
				  'responsiveness' => 'yes',
				  'content_sidebar_responsiveness' => 'no',
				  'favicon_image' => 'http://test.test/wp-content/themes/bridge/img/favicon.ico',
				  'internal_no_ajax_links' => '',
				  'custom_css' => '',
				  'custom_svg_css' => '',
				  'custom_js' => '',
				  'google_analytics_code' => '',
				  'disable_qode_seo' => 'no',
				  'meta_keywords' => '',
				  'meta_description' => '',
				  'google_maps_api_key' => '',
				  'logo_image' => 'http://test.test/wp-content/themes/bridge/img/logo.png',
				  'logo_image_light' => 'http://test.test/wp-content/themes/bridge/img/logo_white.png',
				  'logo_image_dark' => 'http://test.test/wp-content/themes/bridge/img/logo_black.png',
				  'logo_image_sticky' => 'http://test.test/wp-content/themes/bridge/img/logo_black.png',
				  'logo_image_fixed_hidden' => '',
				  'logo_image_mobile' => '',
				  'vertical_logo_bottom' => '',
				  'logo_mobile_header_height' => '',
				  'logo_mobile_height' => '',
				  'vertical_area' => 'no',
				  'header_in_grid' => 'yes',
				  'header_bottom_appearance' => 'regular',
				  'search_left_sidearea_right' => 'no',
				  'scroll_amount_for_sticky' => '',
				  'hide_initial_sticky' => 'no',
				  'scroll_amount_for_fixed_hiding' => '',
				  'menu_position' => '',
				  'center_logo_image' => 'no',
				  'search_left_sidearea_right_regular' => 'no',
				  'center_logo_image_animate' => 'no',
				  'disable_text_shadow_for_sticky' => 'no',
				  'header_height' => '',
				  'header_height_scroll' => '',
				  'header_height_sticky' => '',
				  'header_height_scroll_hidden' => '',
				  'header_fixed_top_logo_background' => '',
				  'header_style' => '',
				  'enable_header_style_on_scroll' => 'no',
				  'header_background_color' => '',
				  'header_background_color_scroll' => '',
				  'header_background_color_sticky' => '',
				  'header_background_transparency_initial' => '',
				  'header_background_transparency_scroll' => '',
				  'header_background_transparency_sticky' => '',
				  'header_bottom_border_color' => '',
				  'header_botom_border_transparency' => '',
				  'header_botom_border_in_grid' => 'no',
				  'sticky_mobile_header' => 'no',
				  'menu_background_color' => '',
				  'dropdown_separator_beetwen_items' => 'no',
				  'dropdown_border_around' => 'no',
				  'header_separator_color' => '',
				  'dropdown_background_color' => '',
				  'dropdown_background_transparency' => '',
				  'enable_wide_manu_background' => 'no',
				  'enable_full_width_wide_menu' => 'no',
				  'enable_search' => 'no',
				  'search_type' => 'search_slides_from_window_top',
				  'search_height' => '',
				  'search_animation' => 'fade',
				  'fullscreen_search_icon_color' => '',
				  'search_cover_only_bottom_yesno' => 'no',
				  'search_icon_pack' => 'font_awesome',
				  'search_background_color' => '',
				  'search_text_color' => '',
				  'search_text_disabled_color' => '',
				  'search_text_fontsize' => '',
				  'search_text_texttransform' => '',
				  'search_text_google_fonts' => '-1',
				  'search_text_fontstyle' => '',
				  'search_text_fontweight' => '',
				  'search_text_letterspacing' => '',
				  'search_label_text_color' => '',
				  'search_label_text_fontsize' => '',
				  'search_label_text_texttransform' => '',
				  'search_label_text_google_fonts' => '-1',
				  'search_label_text_fontstyle' => '',
				  'search_label_text_fontweight' => '',
				  'search_label_text_letterspacing' => '',
				  'header_search_icon_size' => '',
				  'search_icon_color' => '',
				  'search_icon_hover_color' => '',
				  'search_icon_disabled_color' => '',
				  'search_icon_size' => '',
				  'search_close_color' => '',
				  'search_close_hover_color' => '',
				  'search_close_size' => '',
				  'search_border_color' => '',
				  'search_border_focus_color' => '',
				  'enable_side_area' => 'yes',
				  'side_area_type' => 'side_area_uncovered_from_content',
				  'side_area_button_icon_pack' => 'font_awesome',
				  'side_area_icon_icon' => 'fa-bars',
				  'side_area_icon_fe_icon' => 'fa-bars',
				  'side_area_icon_linea_icon' => 'fa-bars',
				  'side_area_icon_dripicon' => 'fa-bars',
				  'side_area_width' => '',
				  'side_area_content_overlay_color' => '',
				  'side_area_content_overlay_opacity' => '',
				  'side_area_slide_with_content_width' => 'width_470',
				  'side_area_title' => '',
				  'side_area_background_color' => '',
				  'side_area_padding_top' => '',
				  'side_area_padding_right' => '',
				  'side_area_padding_bottom' => '',
				  'side_area_padding_left' => '',
				  'side_area_alignment' => '',
				  'side_area_text_color' => '',
				  'side_area_text_hover_color' => '',
				  'side_area_text_lineheight' => '',
				  'side_area_text_texttransform' => '',
				  'side_area_text_font_size' => '',
				  'side_area_text_letter_spacing' => '',
				  'side_area_text_font_weight' => '',
				  'side_area_title_color' => '',
				  'side_area_title_font_size' => '',
				  'side_area_title_letter_spacing' => '',
				  'side_area_title_font_weight' => '',
				  'side_area_close_icon_style' => '',
				  'enable_popup_menu' => 'no',
				  'popup_menu_animation_style' => '',
				  'logo_image_popup' => '',
				  'font_icon_pack_icon_popup' => '',
				  'popup_menu_color' => '',
				  'popup_menu_hover_color' => '',
				  'popup_menu_hover_background_color' => '',
				  'popup_menu_google_fonts' => '-1',
				  'popup_menu_fontsize' => '',
				  'popup_menu_lineheight' => '',
				  'popup_menu_texttransform' => '',
				  'popup_menu_fontstyle' => '',
				  'popup_menu_fontweight' => '',
				  'popup_menu_letterspacing' => '',
				  'popup_menu_color_2nd' => '',
				  'popup_menu_hover_color_2nd' => '',
				  'popup_menu_hover_background_color_2nd' => '',
				  'popup_menu_google_fonts_2nd' => '-1',
				  'popup_menu_fontsize_2nd' => '',
				  'popup_menu_lineheight_2nd' => '',
				  'popup_menu_texttransform_2nd' => '',
				  'popup_menu_fontstyle_2nd' => '',
				  'popup_menu_fontweight_2nd' => '',
				  'popup_menu_letterspacing_2nd' => '',
				  'popup_menu_background_color' => '',
				  'popup_menu_background_transparency' => '',
				  'popup_menu_background_image' => '',
				  'popup_menu_close_button_color' => '',
				  'header_top_area' => 'no',
				  'header_top_area_scroll' => 'no',
				  'hide_top_bar_on_mobile' => 'no',
				  'header_top_height' => '',
				  'header_top_background_color' => '',
				  'top_header_border_color' => '',
				  'top_header_border_weight' => '',
				  'top_header_area_padding' => '',
				  'vertical_area_type' => '',
				  'vertical_area_hidden_button_color' => '',
				  'vertical_area_hidden_button_margin_top' => '',
				  'vertical_area_width' => 'width_260',
				  'vertical_area_transparency' => 'no',
				  'vertical_area_submenu_opening_type' => '',
				  'vertical_area_vertically_center_content' => 'no',
				  'vertical_area_background' => '',
				  'vertical_area_float_dropdown_bckg_color' => '',
				  'vertical_area_float_dropdown_alignment' => '',
				  'vertical_area_background_image' => '',
				  'vertical_area_text_color' => '',
				  'left_menu_alignment' => '',
				  'vertical_menu_color' => '',
				  'vertical_menu_hovercolor' => '',
				  'vertical_menu_google_fonts' => '-1',
				  'vertical_menu_fontsize' => '',
				  'vertical_menu_lineheight' => '',
				  'vertical_menu_fontstyle' => '',
				  'vertical_menu_fontweight' => '',
				  'vertical_menu_letterspacing' => '',
				  'vertical_menu_texttransform' => '',
				  'vertical_dropdown_color' => '',
				  'vertical_dropdown_hovercolor' => '',
				  'vertical_dropdown_google_fonts' => '-1',
				  'vertical_dropdown_fontsize' => '',
				  'vertical_dropdown_lineheight' => '',
				  'vertical_dropdown_fontstyle' => '',
				  'vertical_dropdown_fontweight' => '',
				  'vertical_dropdown_letterspacing' => '',
				  'vertical_dropdown_texttransform' => '',
				  'vertical_dropdown_color_thirdlvl' => '',
				  'vertical_dropdown_hovercolor_thirdlvl' => '',
				  'vertical_dropdown_google_fonts_thirdlvl' => '-1',
				  'vertical_dropdown_fontsize_thirdlvl' => '',
				  'vertical_dropdown_lineheight_thirdlvl' => '',
				  'vertical_dropdown_fontstyle_thirdlvl' => '',
				  'vertical_dropdown_fontweight_thirdlvl' => '',
				  'vertical_dropdown_letterspacing_thirdlvl' => '',
				  'vertical_dropdown_texttransform_thirdlvl' => '',
				  'mobile_separator_color' => '',
				  'mobile_background_color' => '',
				  'mobile_header_top_background_color' => '',
				  'mobile_menu_button_icon_pack' => 'font_awesome',
				  'mobile_menu_icon_icon' => 'fa-bars',
				  'mobile_menu_icon_fe_icon' => 'fa-bars',
				  'mobile_menu_icon_linea_icon' => 'fa-bars',
				  'mobile_menu_icon_dripicon' => 'fa-bars',
				  'header_buttons_color' => '',
				  'header_buttons_hover_color' => '',
				  'header_buttons_font_size' => '',
				  'header_buttons_size' => 'normal',
				  'uncovering_footer' => 'no',
				  'footer_main_image_background' => '',
				  'show_footer_top' => 'yes',
				  'footer_in_grid' => 'yes',
				  'footer_top_columns' => '4',
				  'footer_col1_alignment' => '',
				  'footer_col2_alignment' => '',
				  'footer_col3_alignment' => '',
				  'footer_col4_alignment' => '',
				  'advanced_footer_top_responsive' => 'no',
				  'footer_top_responsive_advanced_width' => '',
				  'footer_top_responsive' => 'no',
				  'footer_top_background_color' => '',
				  'footer_top_title_color' => '',
				  'footer_top_text_color' => '',
				  'footer_link_color' => '',
				  'footer_link_hover_color' => '',
				  'footer_image_background' => '',
				  'footer_top_border_color' => '',
				  'footer_top_border_width' => '',
				  'footer_top_border_in_grid' => 'no',
				  'footer_top_padding_top' => '',
				  'footer_top_padding_right' => '',
				  'footer_top_padding_bottom' => '',
				  'footer_top_padding_left' => '',
				  'footer_angled_section' => 'no',
				  'footer_angled_section_direction' => '',
				  'footer_angled_section_background_color' => '',
				  'footer_text' => 'yes',
				  'footer_bottom_in_grid' => 'no',
				  'footer_bottom_columns' => '1',
				  'footer_bottom_background_color' => '',
				  'footer_bottom_text_color' => '',
				  'footer_bottom_link_hover_color' => '',
				  'footer_bottom_border_color' => '',
				  'footer_bottom_border_width' => '',
				  'footer_bottom_border_in_grid' => 'no',
				  'footer_bottom_padding_top' => '',
				  'footer_bottom_padding_right' => '',
				  'footer_bottom_padding_bottom' => '',
				  'footer_bottom_padding_left' => '',
				  'footer_bottom_image_background' => '',
				  'footer_custom_menu_spacing' => '',
				  'dont_show_page_title' => 'no',
				  'animate_title_area' => 'no',
				  'dont_show_page_title_text' => 'no',
				  'page_title_position' => 'left',
				  'predefined_title_sizes' => 'small',
				  'title_text_shadow' => 'no',
				  'title_text_margin' => '',
				  'title_background_color' => '',
				  'title_image' => '',
				  'responsive_title_image' => 'no',
				  'fixed_title_image' => 'no',
				  'title_height' => '',
				  'title_overlay_image' => '',
				  'title_separator' => 'yes',
				  'title_separator_color' => '',
				  'title_gradient_separator' => 'no',
				  'title_separator_width' => '',
				  'enable_title_angled' => 'no',
				  'title_angled_section_direction' => '',
				  'title_angled_section_color' => '',
				  'border_bottom_title_area' => 'no',
				  'border_bottom_title_area_color' => '',
				  'border_bottom_in_grid_title_area' => 'no',
				  'margin_after_title' => '',
				  'margin_after_title_responsive' => '',
				  'enable_breadcrumbs' => 'no',
				  'breadcrumbs_color' => '',
				  'page_title_whole_content_animations' => 'no',
				  'page_title_whole_content_data_start' => '',
				  'page_title_whole_content_start_custom_style' => '',
				  'page_title_whole_content_data_end' => '',
				  'page_title_whole_content_end_custom_style' => '',
				  'page_title_animations' => 'no',
				  'page_title_data_start' => '',
				  'page_title_start_custom_style' => '',
				  'page_title_data_end' => '',
				  'page_title_end_custom_style' => '',
				  'page_title_separator_animations' => 'no',
				  'page_title_separator_data_start' => '',
				  'page_title_separator_start_custom_style' => '',
				  'page_title_separator_data_end' => '',
				  'page_title_separator_end_custom_style' => '',
				  'page_subtitle_animations' => 'no',
				  'page_subtitle_data_start' => '',
				  'page_subtitle_start_custom_style' => '',
				  'page_subtitle_data_end' => '',
				  'page_subtitle_end_custom_style' => '',
				  'page_title_breadcrumbs_animations' => 'no',
				  'page_title_breadcrumbs_data_start' => '',
				  'page_title_breadcrumbs_start_custom_style' => '',
				  'page_title_breadcrumbs_data_end' => '',
				  'page_title_breadcrumbs_end_custom_style' => '',
				  'h1_color' => '',
				  'h1_fontsize' => '',
				  'h1_lineheight' => '',
				  'h1_texttransform' => '',
				  'h1_google_fonts' => '-1',
				  'h1_fontstyle' => '',
				  'h1_fontweight' => '',
				  'h1_letterspacing' => '',
				  'h2_color' => '',
				  'h2_fontsize' => '',
				  'h2_lineheight' => '',
				  'h2_texttransform' => '',
				  'h2_google_fonts' => '-1',
				  'h2_fontstyle' => '',
				  'h2_fontweight' => '',
				  'h2_letterspacing' => '',
				  'h3_color' => '',
				  'h3_fontsize' => '',
				  'h3_lineheight' => '',
				  'h3_texttransform' => '',
				  'h3_google_fonts' => '-1',
				  'h3_fontstyle' => '',
				  'h3_fontweight' => '',
				  'h3_letterspacing' => '',
				  'h4_color' => '',
				  'h4_fontsize' => '',
				  'h4_lineheight' => '',
				  'h4_texttransform' => '',
				  'h4_google_fonts' => '-1',
				  'h4_fontstyle' => '',
				  'h4_fontweight' => '',
				  'h4_letterspacing' => '',
				  'h5_color' => '',
				  'h5_fontsize' => '',
				  'h5_lineheight' => '',
				  'h5_texttransform' => '',
				  'h5_google_fonts' => '-1',
				  'h5_fontstyle' => '',
				  'h5_fontweight' => '',
				  'h5_letterspacing' => '',
				  'h6_color' => '',
				  'h6_fontsize' => '',
				  'h6_lineheight' => '',
				  'h6_texttransform' => '',
				  'h6_google_fonts' => '-1',
				  'h6_fontstyle' => '',
				  'h6_fontweight' => '',
				  'h6_letterspacing' => '',
				  'h1_fontsize_tablet' => '',
				  'h1_lineheight_tablet' => '',
				  'h1_letterspacing_tablet' => '',
				  'h2_fontsize_tablet' => '',
				  'h2_lineheight_tablet' => '',
				  'h2_letterspacing_tablet' => '',
				  'h3_fontsize_tablet' => '',
				  'h3_lineheight_tablet' => '',
				  'h3_letterspacing_tablet' => '',
				  'h4_fontsize_tablet' => '',
				  'h4_lineheight_tablet' => '',
				  'h4_letterspacing_tablet' => '',
				  'h5_fontsize_tablet' => '',
				  'h5_lineheight_tablet' => '',
				  'h5_letterspacing_tablet' => '',
				  'h6_fontsize_tablet' => '',
				  'h6_lineheight_tablet' => '',
				  'h6_letterspacing_tablet' => '',
				  'h1_fontsize_mobile' => '',
				  'h1_lineheight_mobile' => '',
				  'h1_letterspacing_mobile' => '',
				  'h2_fontsize_mobile' => '',
				  'h2_lineheight_mobile' => '',
				  'h2_letterspacing_mobile' => '',
				  'h3_fontsize_mobile' => '',
				  'h3_lineheight_mobile' => '',
				  'h3_letterspacing_mobile' => '',
				  'h4_fontsize_mobile' => '',
				  'h4_lineheight_mobile' => '',
				  'h4_letterspacing_mobile' => '',
				  'h5_fontsize_mobile' => '',
				  'h5_lineheight_mobile' => '',
				  'h5_letterspacing_mobile' => '',
				  'h6_fontsize_mobile' => '',
				  'h6_lineheight_mobile' => '',
				  'h6_letterspacing_mobile' => '',
				  'text_color' => '',
				  'text_fontsize' => '',
				  'text_lineheight' => '',
				  'text_google_fonts' => '-1',
				  'text_fontstyle' => '',
				  'text_fontweight' => '',
				  'text_margin' => '',
				  'text_fontsize_tablet' => '',
				  'text_lineheight_tablet' => '',
				  'text_letterspacing_tablet' => '',
				  'text_fontsize_mobile' => '',
				  'text_lineheight_mobile' => '',
				  'text_letterspacing_mobile' => '',
				  'link_color' => '',
				  'link_hovercolor' => '',
				  'link_fontstyle' => '',
				  'link_fontweight' => '',
				  'link_fontdecoration' => '',
				  'menu_color' => '',
				  'menu_hovercolor' => '',
				  'menu_activecolor' => '',
				  'menu_hover_background_color' => '',
				  'menu_google_fonts' => '-1',
				  'menu_fontsize' => '',
				  'menu_lineheight' => '',
				  'menu_hover_background_color_transparency' => '',
				  'menu_fontstyle' => '',
				  'menu_fontweight' => '',
				  'menu_letterspacing' => '',
				  'menu_text_transform' => '',
				  'menu_separator_between_items' => 'no',
				  'menu_separator_color' => '',
				  'menu_padding_left_right' => '',
				  'menu_item_border' => 'no',
				  'menu_underline_dash' => 'no',
				  'menu_underline_dash_color' => '',
				  'menu_underline_dash_width' => '',
				  'menu_underline_dash_height' => '',
				  'menu_underline_dash_alignment' => 'center',
				  'dropdown_color' => '',
				  'dropdown_hovercolor' => '',
				  'dropdown_google_fonts' => '-1',
				  'dropdown_fontsize' => '',
				  'dropdown_lineheight' => '',
				  'dropdown_padding_top_bottom' => '',
				  'dropdown_fontstyle' => '',
				  'dropdown_fontweight' => '',
				  'dropdown_letterspacing' => '',
				  'dropdown_texttransform' => '',
				  'dropdown_wide_color' => '',
				  'dropdown_wide_hovercolor' => '',
				  'dropdown_wide_google_fonts' => '-1',
				  'dropdown_wide_fontsize' => '',
				  'dropdown_wide_lineheight' => '',
				  'dropdown_wide_fontstyle' => '',
				  'dropdown_wide_fontweight' => '',
				  'dropdown_wide_letterspacing' => '',
				  'dropdown_wide_texttransform' => '',
				  'dropdown_color_thirdlvl' => '',
				  'dropdown_hovercolor_thirdlvl' => '',
				  'dropdown_google_fonts_thirdlvl' => '-1',
				  'dropdown_fontsize_thirdlvl' => '',
				  'dropdown_lineheight_thirdlvl' => '',
				  'dropdown_fontstyle_thirdlvl' => '',
				  'dropdown_fontweight_thirdlvl' => '',
				  'dropdown_letterspacing_thirdlvl' => '',
				  'dropdown_texttransform_thirdlvl' => '',
				  'fixed_color' => '',
				  'fixed_hovercolor' => '',
				  'fixed_google_fonts' => '-1',
				  'fixed_fontsize' => '',
				  'fixed_lineheight' => '',
				  'fixed_fontstyle' => '',
				  'fixed_fontweight' => '',
				  'fixed_letterspacing' => '',
				  'fixed_texttransform' => '',
				  'sticky_color' => '',
				  'sticky_hovercolor' => '',
				  'sticky_google_fonts' => '-1',
				  'sticky_fontsize' => '',
				  'sticky_lineheight' => '',
				  'sticky_fontstyle' => '',
				  'sticky_fontweight' => '',
				  'sticky_letterspacing' => '',
				  'sticky_texttransform' => '',
				  'mobile_color' => '',
				  'mobile_hovercolor' => '',
				  'mobile_google_fonts' => '-1',
				  'mobile_fontsize' => '',
				  'mobile_lineheight' => '',
				  'mobile_fontstyle' => '',
				  'mobile_fontweight' => '',
				  'mobile_letter_spacing' => '',
				  'mobile_texttransform' => '',
				  'top_header_text_color' => '',
				  'top_header_text_hover_color' => '',
				  'top_header_text_font_family' => '-1',
				  'top_header_text_font_size' => '',
				  'top_header_text_line_height' => '',
				  'top_header_text_font_style' => '',
				  'top_header_text_font_weight' => '',
				  'top_header_text_letter_spacing' => '',
				  'top_header_text_texttransform' => '',
				  'page_title_color' => '',
				  'page_title_fontsize' => '',
				  'page_title_lineheight' => '',
				  'page_title_texttransform' => '',
				  'page_title_google_fonts' => '-1',
				  'page_title_fontstyle' => '',
				  'page_title_fontweight' => '',
				  'page_title_letterspacing' => '',
				  'page_title_medium_fontsize' => '',
				  'page_title_medium_lineheight' => '',
				  'page_title_medium_fontweight' => '',
				  'page_title_medium_letterspacing' => '',
				  'page_title_medium_texttransform' => '',
				  'page_title_large_fontsize' => '',
				  'page_title_large_lineheight' => '',
				  'page_title_large_fontweight' => '',
				  'page_title_large_letterspacing' => '',
				  'page_title_large_texttransform' => '',
				  'small_tablet_title_fs' => '',
				  'small_tablet_title_lh' => '',
				  'small_mobile_title_fs' => '',
				  'small_mobile_title_lh' => '',
				  'medium_tablet_title_fs' => '',
				  'medium_tablet_title_lh' => '',
				  'medium_mobile_title_fs' => '',
				  'medium_mobile_title_lh' => '',
				  'large_tablet_title_fs' => '',
				  'large_tablet_title_lh' => '',
				  'large_mobile_title_fs' => '',
				  'large_mobile_title_lh' => '',
				  'page_subtitle_color' => '',
				  'page_subtitle_fontsize' => '',
				  'page_subtitle_lineheight' => '',
				  'page_subtitle_letter_spacing' => '',
				  'page_subtitle_font_family' => '-1',
				  'page_subtitle_font_style' => '',
				  'page_subtitle_fontweight' => '',
				  'page_subtitle_text_transform' => '',
				  'page_subtitle_large_fontsize' => '',
				  'page_subtitle_large_lineheight' => '',
				  'page_subtitle_large_fontweight' => '',
				  'page_text_above_title_color' => '',
				  'page_text_above_title_fontsize' => '',
				  'page_text_above_title_lineheight' => '',
				  'page_text_above_title_letterspacing' => '',
				  'page_text_above_title_font_family' => '-1',
				  'page_text_above_title_font_style' => '',
				  'page_text_above_title_fontweight' => '',
				  'page_text_above_title_texttransform' => '',
				  'page_text_above_title_large_fontsize' => '',
				  'page_text_above_title_large_lineheight' => '',
				  'page_text_above_title_large_fontweight' => '',
				  'footer_title_color' => '',
				  'footer_title_font_size' => '',
				  'footer_title_letter_spacing' => '',
				  'footer_title_line_height' => '',
				  'footer_title_font_family' => '-1',
				  'footer_title_font_style' => '',
				  'footer_title_font_weight' => '',
				  'footer_title_text_transform' => '',
				  'footer_text_font_size' => '',
				  'footer_text_letter_spacing' => '',
				  'footer_text_line_height' => '',
				  'footer_text_font_family' => '-1',
				  'footer_text_font_style' => '',
				  'footer_text_font_weight' => '',
				  'footer_text_text_transform' => '',
				  'footer_link_font_size' => '',
				  'footer_link_letter_spacing' => '',
				  'footer_link_line_height' => '',
				  'footer_link_font_family' => '-1',
				  'footer_link_font_style' => '',
				  'footer_link_font_weight' => '',
				  'footer_link_text_transform' => '',
				  'footer_bottom_text_font_size' => '',
				  'footer_bottom_text_letter_spacing' => '',
				  'footer_bottom_text_line_height' => '',
				  'footer_bottom_text_font_family' => '-1',
				  'footer_bottom_text_font_style' => '',
				  'footer_bottom_text_font_weight' => '',
				  'footer_bottom_text_text_transform' => '',
				  'footer_bottom_link_font_size' => '',
				  'footer_bottom_link_letter_spacing' => '',
				  'footer_bottom_link_line_height' => '',
				  'footer_bottom_link_font_family' => '-1',
				  'footer_bottom_link_font_style' => '',
				  'footer_bottom_link_font_weight' => '',
				  'footer_bottom_link_text_transform' => '',
				  'portfolio_filter_color' => '',
				  'portfolio_filter_hover_color' => '',
				  'portfolio_filter_font_size' => '',
				  'portfolio_filter_line_height' => '',
				  'portfolio_filter_text_transform' => '',
				  'portfolio_filter_font_family' => '-1',
				  'portfolio_filter_font_style' => '',
				  'portfolio_filter_font_weight' => '',
				  'portfolio_filter_letter_spacing' => '',
				  'separator_color' => '',
				  'separator_color_transparency' => '',
				  'separator_thickness' => '',
				  'separator_topmargin' => '',
				  'separator_bottommargin' => '',
				  'separator_small_color' => '',
				  'separator_small_color_transparency' => '',
				  'separator_small_thickness' => '',
				  'separator_small_width' => '',
				  'separator_small_topmargin' => '',
				  'separator_small_bottommargin' => '',
				  'separator_with_icon_color' => '',
				  'separator_with_icon_transparency' => '',
				  'separator_with_icon_thickness' => '',
				  'separator_with_icon_width' => '',
				  'separator_with_icon_topmargin' => '',
				  'separator_with_icon_bottommargin' => '',
				  'button_title_color' => '',
				  'button_title_hovercolor' => '',
				  'button_title_google_fonts' => '-1',
				  'button_title_fontsize' => '',
				  'button_title_lineheight' => '',
				  'button_title_fontstyle' => '',
				  'button_title_fontweight' => '',
				  'button_title_letter_spacing' => '',
				  'button_title_text_transform' => '',
				  'button_backgroundcolor' => '',
				  'button_backgroundcolor_hover' => '',
				  'button_border_color' => '',
				  'button_border_hover_color' => '',
				  'button_border_width' => '',
				  'button_border_radius' => '',
				  'button_padding_leftright' => '',
				  'button_white_text_color' => '',
				  'button_white_text_color_hover' => '',
				  'button_white_background_color' => '',
				  'button_white_background_color_hover' => '',
				  'button_white_border_color' => '',
				  'button_white_border_color_hover' => '',
				  'button_green_text_color' => '',
				  'button_green_text_color_hover' => '',
				  'button_green_background_color' => '',
				  'button_green_background_color_hover' => '',
				  'button_green_border_color' => '',
				  'button_green_border_color_hover' => '',
				  'small_button_lineheight' => '',
				  'small_button_fontsize' => '',
				  'small_button_fontweight' => '',
				  'small_button_padding' => '',
				  'small_button_border_radius' => '',
				  'large_button_lineheight' => '',
				  'large_button_fontsize' => '',
				  'large_button_fontweight' => '',
				  'large_button_padding' => '',
				  'large_button_border_radius' => '',
				  'big_large_button_lineheight' => '',
				  'big_large_button_fontsize' => '',
				  'big_large_button_fontweight' => '',
				  'big_large_button_padding' => '',
				  'big_large_button_border_radius' => '',
				  'message_title_color' => '',
				  'message_backgroundcolor' => '',
				  'message_title_google_fonts' => '-1',
				  'message_title_fontsize' => '',
				  'message_title_lineheight' => '',
				  'message_title_fontstyle' => '',
				  'message_title_fontweight' => '',
				  'message_icon_color' => '',
				  'message_icon_fontsize' => '',
				  'quote_link_blockqoute_fontsize' => '',
				  'quote_link_blockqoute_lineheight' => '',
				  'quote_link_blockqoute_letterspacing' => '',
				  'quote_link_blockqoute_texttransform' => '',
				  'quote_link_blockqoute_fontfamily' => '-1',
				  'quote_link_blockqoute_fontstyle' => '',
				  'quote_link_blockqoute_fontweight' => '',
				  'blockquote_font_color' => '',
				  'blockquote_background_color' => '',
				  'blockquote_border_color' => '',
				  'blockquote_quote_icon_color' => '',
				  'social_icon_color' => '',
				  'social_icon_background_color' => '',
				  'social_icon_border_color' => '',
				  'testimonaials_navigation_border_radius' => '',
				  'testimonials_text_color' => '',
				  'testimonaials_font_size' => '',
				  'testimonials_text_line_height' => '',
				  'testimonials_text_text_transform' => '',
				  'testimonials_text_font_family' => '-1',
				  'testimonials_text_font_style' => '',
				  'testimonials_text_font_weight' => '',
				  'testimonials_text_letter_spacing' => '',
				  'testimonials_author_color' => '',
				  'testimonials_author_font_size' => '',
				  'testimonials_author_line_height' => '',
				  'testimonials_author_text_transform' => '',
				  'testimonials_author_font_family' => '-1',
				  'testimonials_author_font_style' => '',
				  'testimonials_author_font_weight' => '',
				  'testimonials_author_letter_spacing' => '',
				  'counter_color' => '',
				  'counter_text_color' => '',
				  'counter_separator_color' => '',
				  'counters_font_size' => '',
				  'counters_font_family' => '-1',
				  'counters_fontweight' => '',
				  'counters_text_font_size' => '',
				  'counters_text_font_family' => '-1',
				  'counters_text_fontweight' => '',
				  'counters_text_texttransform' => '',
				  'counters_text_letterspacing' => '',
				  'counters_text_lineheight' => '',
				  'progress_bar_horizontal_fontsize' => '',
				  'progress_bar_horizontal_fontweight' => '',
				  'pie_charts_fontsize' => '',
				  'pie_charts_fontweight' => '',
				  'tabs_color' => '',
				  'tabs_hover_color' => '',
				  'tabs_active_color' => '',
				  'tabs_text_size' => '',
				  'tabs_line_height' => '',
				  'tabs_text_transform' => '',
				  'tabs_font_family' => '-1',
				  'tabs_font_style' => '',
				  'tabs_fontweight' => '',
				  'tabs_letter_spacing' => '',
				  'tabs_border_color' => '',
				  'tabs_border_radius' => '',
				  'tabs_border_width' => '',
				  'tags_color' => '',
				  'tags_font_size' => '',
				  'tags_line_height' => '',
				  'tags_text_transform' => '',
				  'tags_font_family' => '-1',
				  'tags_font_style' => '',
				  'tags_font_weight' => '',
				  'tags_letter_spacing' => '',
				  'tags_hover_color' => '',
				  'tags_background_color' => '',
				  'tags_background_hover_color' => '',
				  'tags_border_radius' => '',
				  'tags_border_color' => '',
				  'tags_border_hover_color' => '',
				  'tags_border_width' => '',
				  'tags_border_style' => '',
				  'tags_left_right_padding' => '',
				  'process_circle_hover_background_color' => '',
				  'process_text_in_circle_font_weight' => '',
				  'process_text_hover_color' => '',
				  'input_background_color' => '',
				  'input_border_color' => '',
				  'input_text_color' => '',
				  'highlight_color' => '',
				  'toggle_title_background_color' => '',
				  'toggle_title_hover_background_color' => '',
				  'toggle_title_text_background_color' => '',
				  'toggle_title_hover_text_background_color' => '',
				  'qode_back_to_top_icon_pack' => 'font_awesome',
				  'qode_back_to_top_icon_pack_icon' => 'fa-arrow-up',
				  'qode_back_to_top_icon_pack_fe_icon' => 'fa-arrow-up',
				  'qode_back_to_top_icon_pack_linea_icon' => 'fa-arrow-up',
				  'qode_back_to_top_icon_pack_dripicon' => 'fa-arrow-up',
				  'back_to_top_icon_color' => '',
				  'back_to_top_icon_hover_color' => '',
				  'back_to_top_background_color' => '',
				  'back_to_top_background_hover_color' => '',
				  'back_to_top_background_transparency' => '',
				  'back_to_top_background_hover_transparency' => '',
				  'back_to_top_border_color' => '',
				  'back_to_top_border_hover_color' => '',
				  'back_to_top_border_width' => '',
				  'back_to_top_border_radius' => '',
				  'back_to_top_border_transparency' => '',
				  'back_to_top_border_hover_transparency' => '',
				  'back_to_top_height' => '',
				  'back_to_top_width' => '',
				  'back_to_top_right_pos' => '',
				  'back_to_top_bottom_pos' => '',
				  'navigation_area_size' => '',
				  'navigation_button_width' => '',
				  'navigation_button_height' => '',
				  'navigation_button_position' => '',
				  'navigation_arrow_color' => '',
				  'navigation_arrow_transparency' => '',
				  'navigation_arrow_hover_color' => '',
				  'navigation_arrow_hover_transparency' => '',
				  'navigation_arrow_size' => '',
				  'navigation_background_color' => '',
				  'navigation_background_transparency' => '',
				  'navigation_background_hover_color' => '',
				  'navigation_background_hover_transparency' => '',
				  'navigation_border_color' => '',
				  'navigation_border_transparency' => '',
				  'navigation_border_hover_color' => '',
				  'navigation_border_hover_transparency' => '',
				  'navigation_border_width' => '',
				  'navigation_border_radius' => '',
				  'carousel_navigation_button_width' => '',
				  'carousel_navigation_button_height' => '',
				  'carousel_navigation_button_position' => '',
				  'carousel_navigation_arrow_color' => '',
				  'carousel_navigation_arrow_transparency' => '',
				  'carousel_navigation_arrow_hover_color' => '',
				  'carousel_navigation_arrow_hover_transparency' => '',
				  'carousel_navigation_arrow_size' => '',
				  'carousel_navigation_background_color' => '',
				  'carousel_navigation_background_transparency' => '',
				  'carousel_navigation_background_hover_color' => '',
				  'carousel_navigation_background_hover_transparency' => '',
				  'carousel_navigation_border_color' => '',
				  'carousel_navigation_border_transparency' => '',
				  'carousel_navigation_border_hover_color' => '',
				  'carousel_navigation_border_hover_transparency' => '',
				  'carousel_navigation_border_width' => '',
				  'carousel_navigation_border_radius' => '',
				  'single_slider_navigation_button_width' => '',
				  'single_slider_navigation_button_height' => '',
				  'single_slider_navigation_button_position' => '',
				  'single_slider_navigation_arrow_color' => '',
				  'single_slider_navigation_arrow_transparency' => '',
				  'single_slider_navigation_arrow_hover_color' => '',
				  'single_slider_navigation_arrow_hover_transparency' => '',
				  'single_slider_navigation_arrow_size' => '',
				  'single_slider_navigation_background_color' => '',
				  'single_slider_navigation_background_transparency' => '',
				  'single_slider_navigation_background_hover_color' => '',
				  'single_slider_navigation_background_hover_transparency' => '',
				  'single_slider_navigation_border_color' => '',
				  'single_slider_navigation_border_transparency' => '',
				  'single_slider_navigation_border_hover_color' => '',
				  'single_slider_navigation_border_hover_transparency' => '',
				  'single_slider_navigation_border_width' => '',
				  'single_slider_navigation_border_radius' => '',
				  'slider_circle_navigation_position' => '',
				  'button_navigation_color' => '',
				  'button_navigation_active_color' => '',
				  'button_navigation_size' => '',
				  'button_navigation_border_radius' => '',
				  'button_navigation_border_color' => '',
				  'button_navigation_active_border_color' => '',
				  'button_bullet_navigation_color' => '',
				  'button_bullet_navigation_active_color' => '',
				  'button_bullet_navigation_size' => '',
				  'button_bullet_navigation_border_radius' => '',
				  'button_bullet_navigation_border_color' => '',
				  'button_bullet_navigation_active_border_color' => '',
				  'masonry_gallery_space' => '',
				  'masonry_gallery_square_big_title_color' => '',
				  'masonry_gallery_square_big_title_font_size' => '',
				  'masonry_gallery_square_big_title_line_height' => '',
				  'masonry_gallery_square_big_title_text_transform' => '',
				  'masonry_gallery_square_big_title_font_family' => '-1',
				  'masonry_gallery_square_big_title_font_style' => '',
				  'masonry_gallery_square_big_title_font_weight' => '',
				  'masonry_gallery_square_big_title_letter_spacing' => '',
				  'masonry_gallery_square_big_title_margin_bottom' => '',
				  'masonry_gallery_square_big_text_color' => '',
				  'masonry_gallery_square_big_text_font_size' => '',
				  'masonry_gallery_square_big_text_line_height' => '',
				  'masonry_gallery_square_big_text_text_transform' => '',
				  'masonry_gallery_square_big_text_font_family' => '-1',
				  'masonry_gallery_square_big_text_font_style' => '',
				  'masonry_gallery_square_big_text_font_weight' => '',
				  'masonry_gallery_square_big_text_letter_spacing' => '',
				  'masonry_gallery_square_big_button_font_family' => '-1',
				  'masonry_gallery_square_big_button_font_style' => '',
				  'masonry_gallery_square_big_button_font_weight' => '',
				  'masonry_gallery_square_big_button_text_transform' => '',
				  'masonry_gallery_square_big_button_font_size' => '',
				  'masonry_gallery_square_big_button_line_height' => '',
				  'masonry_gallery_square_big_button_letter_spacing' => '',
				  'masonry_gallery_square_big_button_text_color' => '',
				  'masonry_gallery_square_big_button_hover_text_color' => '',
				  'masonry_gallery_square_big_button_background_color' => '',
				  'masonry_gallery_square_big_button_hover_background_color' => '',
				  'masonry_gallery_square_big_button_border_color' => '',
				  'masonry_gallery_square_big_button_hover_border_color' => '',
				  'masonry_gallery_square_big_button_border_width' => '',
				  'masonry_gallery_square_big_button_border_radius' => '',
				  'masonry_gallery_square_big_button_padding_left' => '',
				  'masonry_gallery_square_big_button_padding_right' => '',
				  'masonry_gallery_square_big_button_margin_top' => '',
				  'masonry_gallery_square_big_icon_color' => '',
				  'masonry_gallery_square_big_icon_hover_color' => '',
				  'masonry_gallery_square_big_icon_size' => '',
				  'masonry_gallery_square_big_icon_margin_bottom' => '',
				  'masonry_gallery_square_big_overlay_color' => '',
				  'masonry_gallery_square_big_overlay_transparency' => '',
				  'masonry_gallery_square_big_text_align' => 'center',
				  'masonry_gallery_square_big_padding_left' => '',
				  'masonry_gallery_square_big_padding_right' => '',
				  'masonry_gallery_square_small_title_color' => '',
				  'masonry_gallery_square_small_title_font_size' => '',
				  'masonry_gallery_square_small_title_line_height' => '',
				  'masonry_gallery_square_small_title_text_transform' => '',
				  'masonry_gallery_square_small_title_font_family' => '-1',
				  'masonry_gallery_square_small_title_font_style' => '',
				  'masonry_gallery_square_small_title_font_weight' => '',
				  'masonry_gallery_square_small_title_letter_spacing' => '',
				  'masonry_gallery_square_small_title_margin_bottom' => '',
				  'masonry_gallery_square_small_text_color' => '',
				  'masonry_gallery_square_small_text_font_size' => '',
				  'masonry_gallery_square_small_text_line_height' => '',
				  'masonry_gallery_square_small_text_text_transform' => '',
				  'masonry_gallery_square_small_text_font_family' => '-1',
				  'masonry_gallery_square_small_text_font_style' => '',
				  'masonry_gallery_square_small_text_font_weight' => '',
				  'masonry_gallery_square_small_text_letter_spacing' => '',
				  'masonry_gallery_square_small_button_font_family' => '-1',
				  'masonry_gallery_square_small_button_font_style' => '',
				  'masonry_gallery_square_small_button_font_weight' => '',
				  'masonry_gallery_square_small_button_text_transform' => '',
				  'masonry_gallery_square_small_button_font_size' => '',
				  'masonry_gallery_square_small_button_line_height' => '',
				  'masonry_gallery_square_small_button_letter_spacing' => '',
				  'masonry_gallery_square_small_button_text_color' => '',
				  'masonry_gallery_square_small_button_hover_text_color' => '',
				  'masonry_gallery_square_small_button_background_color' => '',
				  'masonry_gallery_square_small_button_hover_background_color' => '',
				  'masonry_gallery_square_small_button_border_color' => '',
				  'masonry_gallery_square_small_button_hover_border_color' => '',
				  'masonry_gallery_square_small_button_border_width' => '',
				  'masonry_gallery_square_small_button_border_radius' => '',
				  'masonry_gallery_square_small_button_padding_left' => '',
				  'masonry_gallery_square_small_button_padding_right' => '',
				  'masonry_gallery_square_small_button_margin_top' => '',
				  'masonry_gallery_square_small_icon_color' => '',
				  'masonry_gallery_square_small_icon_hover_color' => '',
				  'masonry_gallery_square_small_icon_size' => '',
				  'masonry_gallery_square_small_icon_margin_bottom' => '',
				  'masonry_gallery_square_small_overlay_color' => '',
				  'masonry_gallery_square_small_overlay_transparency' => '',
				  'masonry_gallery_square_small_text_align' => 'center',
				  'masonry_gallery_square_small_padding_left' => '',
				  'masonry_gallery_square_small_padding_right' => '',
				  'masonry_gallery_rectangle_portrait_title_color' => '',
				  'masonry_gallery_rectangle_portrait_title_font_size' => '',
				  'masonry_gallery_rectangle_portrait_title_line_height' => '',
				  'masonry_gallery_rectangle_portrait_title_text_transform' => '',
				  'masonry_gallery_rectangle_portrait_title_font_family' => '-1',
				  'masonry_gallery_rectangle_portrait_title_font_style' => '',
				  'masonry_gallery_rectangle_portrait_title_font_weight' => '',
				  'masonry_gallery_rectangle_portrait_title_letter_spacing' => '',
				  'masonry_gallery_rectangle_portrait_title_margin_bottom' => '',
				  'masonry_gallery_rectangle_portrait_text_color' => '',
				  'masonry_gallery_rectangle_portrait_text_font_size' => '',
				  'masonry_gallery_rectangle_portrait_text_line_height' => '',
				  'masonry_gallery_rectangle_portrait_text_text_transform' => '',
				  'masonry_gallery_rectangle_portrait_text_font_family' => '-1',
				  'masonry_gallery_rectangle_portrait_text_font_style' => '',
				  'masonry_gallery_rectangle_portrait_text_font_weight' => '',
				  'masonry_gallery_rectangle_portrait_text_letter_spacing' => '',
				  'masonry_gallery_rectangle_portrait_button_font_family' => '-1',
				  'masonry_gallery_rectangle_portrait_button_font_style' => '',
				  'masonry_gallery_rectangle_portrait_button_font_weight' => '',
				  'masonry_gallery_rectangle_portrait_button_text_transform' => '',
				  'masonry_gallery_rectangle_portrait_button_font_size' => '',
				  'masonry_gallery_rectangle_portrait_button_line_height' => '',
				  'masonry_gallery_rectangle_portrait_button_letter_spacing' => '',
				  'masonry_gallery_rectangle_portrait_button_text_color' => '',
				  'masonry_gallery_rectangle_portrait_button_hover_text_color' => '',
				  'masonry_gallery_rectangle_portrait_button_background_color' => '',
				  'masonry_gallery_rectangle_portrait_button_hover_background_color' => '',
				  'masonry_gallery_rectangle_portrait_button_border_color' => '',
				  'masonry_gallery_rectangle_portrait_button_hover_border_color' => '',
				  'masonry_gallery_rectangle_portrait_button_border_width' => '',
				  'masonry_gallery_rectangle_portrait_button_border_radius' => '',
				  'masonry_gallery_rectangle_portrait_button_padding_left' => '',
				  'masonry_gallery_rectangle_portrait_button_padding_right' => '',
				  'masonry_gallery_rectangle_portrait_button_margin_top' => '',
				  'masonry_gallery_rectangle_portrait_icon_color' => '',
				  'masonry_gallery_rectangle_portrait_icon_hover_color' => '',
				  'masonry_gallery_rectangle_portrait_icon_size' => '',
				  'masonry_gallery_rectangle_portrait_icon_margin_bottom' => '',
				  'masonry_gallery_rectangle_portrait_overlay_color' => '',
				  'masonry_gallery_rectangle_portrait_overlay_transparency' => '',
				  'masonry_gallery_rectangle_portrait_text_align' => 'center',
				  'masonry_gallery_rectangle_portrait_padding_left' => '',
				  'masonry_gallery_rectangle_portrait_padding_right' => '',
				  'masonry_gallery_rectangle_landscape_title_color' => '',
				  'masonry_gallery_rectangle_landscape_title_font_size' => '',
				  'masonry_gallery_rectangle_landscape_title_line_height' => '',
				  'masonry_gallery_rectangle_landscape_title_text_transform' => '',
				  'masonry_gallery_rectangle_landscape_title_font_family' => '-1',
				  'masonry_gallery_rectangle_landscape_title_font_style' => '',
				  'masonry_gallery_rectangle_landscape_title_font_weight' => '',
				  'masonry_gallery_rectangle_landscape_title_letter_spacing' => '',
				  'masonry_gallery_rectangle_landscape_title_margin_bottom' => '',
				  'masonry_gallery_rectangle_landscape_text_color' => '',
				  'masonry_gallery_rectangle_landscape_text_font_size' => '',
				  'masonry_gallery_rectangle_landscape_text_line_height' => '',
				  'masonry_gallery_rectangle_landscape_text_text_transform' => '',
				  'masonry_gallery_rectangle_landscape_text_font_family' => '-1',
				  'masonry_gallery_rectangle_landscape_text_font_style' => '',
				  'masonry_gallery_rectangle_landscape_text_font_weight' => '',
				  'masonry_gallery_rectangle_landscape_text_letter_spacing' => '',
				  'masonry_gallery_rectangle_landscape_button_font_family' => '-1',
				  'masonry_gallery_rectangle_landscape_button_font_style' => '',
				  'masonry_gallery_rectangle_landscape_button_font_weight' => '',
				  'masonry_gallery_rectangle_landscape_button_text_transform' => '',
				  'masonry_gallery_rectangle_landscape_button_font_size' => '',
				  'masonry_gallery_rectangle_landscape_button_line_height' => '',
				  'masonry_gallery_rectangle_landscape_button_letter_spacing' => '',
				  'masonry_gallery_rectangle_landscape_button_text_color' => '',
				  'masonry_gallery_rectangle_landscape_button_hover_text_color' => '',
				  'masonry_gallery_rectangle_landscape_button_background_color' => '',
				  'masonry_gallery_rectangle_landscape_button_hover_background_color' => '',
				  'masonry_gallery_rectangle_landscape_button_border_color' => '',
				  'masonry_gallery_rectangle_landscape_button_hover_border_color' => '',
				  'masonry_gallery_rectangle_landscape_button_border_width' => '',
				  'masonry_gallery_rectangle_landscape_button_border_radius' => '',
				  'masonry_gallery_rectangle_landscape_button_padding_left' => '',
				  'masonry_gallery_rectangle_landscape_button_padding_right' => '',
				  'masonry_gallery_rectangle_landscape_button_margin_top' => '',
				  'masonry_gallery_rectangle_landscape_icon_color' => '',
				  'masonry_gallery_rectangle_landscape_icon_hover_color' => '',
				  'masonry_gallery_rectangle_landscape_icon_size' => '',
				  'masonry_gallery_rectangle_landscape_icon_margin_bottom' => '',
				  'masonry_gallery_rectangle_landscape_overlay_color' => '',
				  'masonry_gallery_rectangle_landscape_overlay_transparency' => '',
				  'masonry_gallery_rectangle_landscape_text_align' => 'center',
				  'masonry_gallery_rectangle_landscape_padding_left' => '',
				  'masonry_gallery_rectangle_landscape_padding_right' => '',
				  'fss_navigation_button_width' => '',
				  'fss_navigation_button_height' => '',
				  'fss_navigation_button_position' => '',
				  'fss_navigation_button_up_position' => '',
				  'fss_navigation_button_down_position' => '',
				  'fss_navigation_arrow_color' => '',
				  'fss_navigation_arrow_transparency' => '',
				  'fss_navigation_arrow_hover_color' => '',
				  'fss_navigation_arrow_hover_transparency' => '',
				  'fss_navigation_arrow_size' => '',
				  'fss_navigation_background_color' => '',
				  'fss_navigation_background_transparency' => '',
				  'fss_navigation_background_hover_color' => '',
				  'fss_navigation_background_hover_transparency' => '',
				  'fss_navigation_border_color' => '',
				  'fss_navigation_border_transparency' => '',
				  'fss_navigation_border_hover_color' => '',
				  'fss_navigation_border_hover_transparency' => '',
				  'fss_navigation_border_width' => '',
				  'fss_navigation_border_radius' => '',
				  'button_v2_font_size' => '',
				  'button_v2_line_height' => '',
				  'button_v2_letter_spacing' => '',
				  'button_v2_font_family' => '',
				  'button_v2_text_transform' => '',
				  'button_v2_font_style' => '',
				  'button_v2_font_weight' => '',
				  'button_v2_border_radius' => '',
				  'button_v2_padding' => '',
				  'btn_v2_solid_text_color' => '',
				  'btn_v2_solid_hover_text_color' => '',
				  'btn_v2_solid_bg_color' => '',
				  'btn_v2_solid_hover_bg_color' => '',
				  'btn_v2_solid_icon_border_color' => '',
				  'btn_v2_solid_icon_border_hover_color' => '',
				  'btn_v2_solid_icon_bg_color' => '',
				  'btn_v2_solid_icon_bg_hover_color' => '',
				  'breadcrumbs_font_size' => '',
				  'breadcrumbs_line_height' => '',
				  'breadcrumbs_transform' => '',
				  'breadcrumbs_font_family' => '',
				  'breadcrumbs_font_style' => '',
				  'breadcrumbs_font_weight' => '',
				  'breadcrumbs_letter_spacing' => '',
				  'breadcrumbs_delimiter_sign' => '',
				  'accordions_font_family' => '',
				  'accordions_text_transform' => '',
				  'accordions_font_style' => '',
				  'accordions_letter_spacing' => '',
				  'accordions_font_weight' => '',
				  'accordions_title_color' => '',
				  'accordions_back_color' => '',
				  'accordions_title_color_active' => '',
				  'accordions_back_color_active' => '',
				  'advanced_pricing_table_border_color' => '',
				  'advanced_pricing_table_odd_bckg_color' => '',
				  'advanced_pricing_table_even_bckg_color' => '',
				  'advanced_tabs_color' => '',
				  'advanced_tabs_bckg_color' => '',
				  'advanced_tabs_hover_color' => '',
				  'advanced_tabs_hover_bckg_color' => '',
				  'comparative_features_table_border_color' => '',
				  'comparative_features_table_odd_bckg_color' => '',
				  'comparative_features_table_even_bckg_color' => '',
				  'comparative_features_table_btn_font_family' => '',
				  'comparative_features_table_btn_font_size' => '',
				  'comparative_features_table_btn_font_weight' => '',
				  'comparative_features_table_btn_font_style' => '',
				  'comparative_features_table_btn_text_transform' => '',
				  'comparative_features_table_btn_letter_spacing' => '',
				  'comparative_features_table_btn_color' => '',
				  'comparative_features_table_btn_hover_color' => '',
				  'numbered_process_border_color' => '',
				  'numbered_process_border_width' => '',
				  'numbered_process_number_color' => '',
				  'numbered_process_number_font_size' => '',
				  'numbered_process_number_background_color' => '',
				  'numbered_process_item_border_color' => '',
				  'numbered_process_item_border_width' => '',
				  'pricing_calculator_border_color' => '',
				  'pricing_calculator_left_section_bckg_color' => '',
				  'pricing_calculator_right_section_bckg_color' => '',
				  'pricing_calculator_switch_color' => '',
				  'pricing_calculator_switch_active_color' => '',
				  'pricing_calculator_price_font_family' => '',
				  'pricing_calculator_price_font_size' => '',
				  'pricing_calculator_price_font_weight' => '',
				  'pricing_calculator_price_font_style' => '',
				  'pricing_calculator_price_letter_spacing' => '',
				  'pricing_calculator_price_color' => '',
				  'report_sheet_border_color' => '',
				  'rs_header_bckg_color' => '',
				  'rs_odd_bckg_color' => '',
				  'rs_even_bckg_color' => '',
				  'rs_btn_font_family' => '',
				  'report_sheet_btn_font_size' => '',
				  'rs_btn_font_weight' => '',
				  'rs_btn_font_style' => '',
				  'rs_btn_text_transform' => '',
				  'rs_table_btn_letter_spacing' => '',
				  'rs_btn_color' => '',
				  'rs_btn_hover_color' => '',
				  'sq_text_font_family' => '',
				  'sq_text_font_size' => '',
				  'sq_text_font_weight' => '',
				  'sq_text_line_height' => '',
				  'sq_text_font_style' => '',
				  'sq_text_text_transform' => '',
				  'sq_text_letter_spacing' => '',
				  'sq_text_color' => '',
				  'sq_author_font_family' => '',
				  'sq_author_font_size' => '',
				  'sq_author_font_weight' => '',
				  'sq_author_line_height' => '',
				  'sq_author_font_style' => '',
				  'sq_author_text_transform' => '',
				  'sq_author_letter_spacing' => '',
				  'sq_author_color' => '',
				  'testimonial_carousel_border_radius' => '',
				  'testimonial_carousel_background_color' => '',
				  'tc_text_color' => '',
				  'tc_text_font_size' => '',
				  'tc_text_line_height' => '',
				  'tc_text_transform' => '',
				  'tc_text_font_family' => '',
				  'tc_text_font_style' => '',
				  'tc_text_font_weight' => '',
				  'tc_text_letter_spacing' => '',
				  'tc_author_color' => '',
				  'tc_author_font_size' => '',
				  'tc_author_line_height' => '',
				  'tc_author_transform' => '',
				  'tc_author_font_family' => '',
				  'tc_author_font_style' => '',
				  'tc_author_font_weight' => '',
				  'tc_author_letter_spacing' => '',
				  'video_box_circle_color' => '',
				  'video_box_circle_hover_color' => '',
				  'video_box_icon_color' => '',
				  'video_box_icon_hover_color' => '',
				  'video_box_border_width' => '',
				  'video_box_border_color' => '',
				  'video_box_border_hover_color' => '',
				  'video_box_height_width' => '',
				  'sidebar_title_color' => '',
				  'sidebar_title_fontsize' => '',
				  'sidebar_title_lineheight' => '',
				  'sidebar_title_texttransform' => '',
				  'sidebar_title_google_fonts' => '-1',
				  'sidebar_title_fontstyle' => '',
				  'sidebar_title_fontweight' => '',
				  'sidebar_title_letterspacing' => '',
				  'sidebar_text_color' => '',
				  'sidebar_text_fontsize' => '',
				  'sidebar_text_lineheight' => '',
				  'sidebar_text_texttransform' => '',
				  'sidebar_text_google_fonts' => '-1',
				  'sidebar_text_fontstyle' => '',
				  'sidebar_text_fontweight' => '',
				  'sidebar_text_letterspacing' => '',
				  'sidebar_link_color' => '',
				  'sidebar_link_hover_color' => '',
				  'sidebar_link_fontsize' => '',
				  'sidebar_link_lineheight' => '',
				  'sidebar_link_texttransform' => '',
				  'sidebar_link_google_fonts' => '-1',
				  'sidebar_link_fontstyle' => '',
				  'sidebar_link_fontweight' => '',
				  'sidebar_link_letterspacing' => '',
				  'qs_slider_height_tablet' => '',
				  'qs_slider_height_mobile' => '',
				  'qs_button_color' => '',
				  'qs_button_hover_color' => '',
				  'qs_button_background_color' => '',
				  'qs_button_hover_background_color' => '',
				  'qs_button_border_color' => '',
				  'qs_button_hover_border_color' => '',
				  'qs_button_border_width' => '',
				  'qs_button_border_radius' => '',
				  'qs_button2_color' => '',
				  'qs_button2_hover_color' => '',
				  'qs_button2_background_color' => '',
				  'qs_button2_hover_background_color' => '',
				  'qs_button2_border_color' => '',
				  'qs_button2_hover_border_color' => '',
				  'qs_button2_border_width' => '',
				  'qs_button2_border_radius' => '',
				  'qs_v2_button_color' => '',
				  'qs_v2_button_hover_color' => '',
				  'qs_v2_button_background_color' => '',
				  'qs_v2_button_hover_background_color' => '',
				  'qs_v2_button_icon_left_border_color' => '',
				  'qs_v2_button_hover_icon_left_border_color' => '',
				  'qs_v2_button_icon_background_color' => '',
				  'qs_v2_button_hover_icon_background_color' => '',
				  'qs_v2_button2_color' => '',
				  'qs_v2_button2_hover_color' => '',
				  'qs_v2_button2_background_color' => '',
				  'qs_v2_button2_hover_background_color' => '',
				  'qs_v2_button2_icon_left_border_color' => '',
				  'qs_v2_button2_hover_icon_left_border_color' => '',
				  'qs_v2_button2_icon_background_color' => '',
				  'qs_v2_button2_hover_icon_background_color' => '',
				  'qs_enable_navigation_custom_cursor' => 'no',
				  'cursor_image_left_right_area_size' => '',
				  'cursor_image_left_normal' => '',
				  'cursor_image_right_normal' => '',
				  'cursor_image_left_light' => '',
				  'cursor_image_right_light' => '',
				  'cursor_image_left_dark' => '',
				  'cursor_image_right_dark' => '',
				  'qs_enable_navigation_custom_cursor_grab' => 'no',
				  'cursor_image_grab_normal' => '',
				  'cursor_image_grab_light' => '',
				  'cursor_image_grab_dark' => '',
				  'inter_page_navigation' => 'no',
				  'inter_page_navigation_in_grid' => 'no',
				  'inter_page_navigation_background_color' => '',
				  'inter_page_icons_gradient' => 'no',
				  'inter_page_back_link' => 'no-link',
				  'inter_page_order_by' => 'post_title',
				  'search_results_columns' => 'one-column',
				  'search_results_spacing' => 'no',
				  'pagination' => '1',
				  'blog_style' => '1',
				  'category_blog_sidebar' => 'default',
				  'blog_hide_comments' => 'no',
				  'blog_hide_author' => 'no',
				  'qode_like' => 'on',
				  'blog_page_range' => '',
				  'number_of_chars' => '45',
				  'number_of_chars_masonry' => '',
				  'number_of_chars_large_image' => '',
				  'number_of_chars_small_image' => '',
				  'blog_content_position' => 'content_above_blog_list',
				  'pagination_masonry' => 'pagination',
				  'blog_masonry_filter' => 'no',
				  'blog_masonry_padding' => '',
				  'blog_large_image_text_in_box' => '',
				  'blog_large_image_border' => '',
				  'blog_large_image_border_width' => '',
				  'blog_large_image_background_color' => '',
				  'blog_large_image_border_color' => '',
				  'blog_large_image_title_color' => '',
				  'blog_large_image_title_hover_color' => '',
				  'blog_large_image_title_date_color' => '',
				  'blog_large_image_title_fontsize' => '',
				  'blog_large_image_title_lineheight' => '',
				  'blog_large_image_title_texttransform' => '',
				  'blog_large_image_title_google_fonts' => '-1',
				  'blog_large_image_title_fontstyle' => '',
				  'blog_large_image_title_fontweight' => '',
				  'blog_large_image_title_letterspacing' => '',
				  'blog_large_image_post_info_color' => '',
				  'blog_large_image_post_info_link_color' => '',
				  'blog_large_image_post_info_link_hover_color' => '',
				  'blog_large_image_post_info_fontsize' => '',
				  'blog_large_image_post_info_lineheight' => '',
				  'blog_large_image_post_info_texttransform' => '',
				  'blog_large_image_post_info_google_fonts' => '-1',
				  'blog_large_image_post_info_fontstyle' => '',
				  'blog_large_image_post_info_fontweight' => '',
				  'blog_large_image_post_info_letterspacing' => '',
				  'blog_large_image_ql_post_info_color' => '',
				  'blog_large_image_ql_post_info_link_color' => '',
				  'blog_large_image_ql_post_info_link_hover_color' => '',
				  'blog_large_image_ql_post_info_fontsize' => '',
				  'blog_large_image_ql_post_info_lineheight' => '',
				  'blog_large_image_ql_post_info_texttransform' => '',
				  'blog_large_image_ql_post_info_google_fonts' => '-1',
				  'blog_large_image_ql_post_info_fontstyle' => '',
				  'blog_large_image_ql_post_info_fontweight' => '',
				  'blog_large_image_ql_post_info_letterspacing' => '',
				  'blog_small_image_text_in_box' => '',
				  'blog_small_image_border' => '',
				  'blog_small_image_border_width' => '',
				  'blog_small_image_background_color' => '',
				  'blog_small_image_border_color' => '',
				  'blog_small_image_title_color' => '',
				  'blog_small_image_title_hover_color' => '',
				  'blog_small_image_title_date_color' => '',
				  'blog_small_image_title_fontsize' => '',
				  'blog_small_image_title_lineheight' => '',
				  'blog_small_image_title_texttransform' => '',
				  'blog_small_image_title_google_fonts' => '-1',
				  'blog_small_image_title_fontstyle' => '',
				  'blog_small_image_title_fontweight' => '',
				  'blog_small_image_title_letterspacing' => '',
				  'blog_small_image_post_info_color' => '',
				  'blog_small_image_post_info_link_color' => '',
				  'blog_small_image_post_info_link_hover_color' => '',
				  'blog_small_image_post_info_fontsize' => '',
				  'blog_small_image_post_info_lineheight' => '',
				  'blog_small_image_post_info_texttransform' => '',
				  'blog_small_image_post_info_google_fonts' => '-1',
				  'blog_small_image_post_info_fontstyle' => '',
				  'blog_small_image_post_info_fontweight' => '',
				  'blog_small_image_post_info_letterspacing' => '',
				  'blog_small_image_ql_post_info_color' => '',
				  'blog_small_image_ql_post_info_link_color' => '',
				  'blog_small_image_ql_post_info_link_hover_color' => '',
				  'blog_small_image_ql_post_info_fontsize' => '',
				  'blog_small_image_ql_post_info_lineheight' => '',
				  'blog_small_image_ql_post_info_texttransform' => '',
				  'blog_small_image_ql_post_info_google_fonts' => '-1',
				  'blog_small_image_ql_post_info_fontstyle' => '',
				  'blog_small_image_ql_post_info_fontweight' => '',
				  'blog_small_image_ql_post_info_letterspacing' => '',
				  'blog_masonry_background_color' => '',
				  'blog_masonry_border_color' => '',
				  'blog_masonry_border_radius' => '',
				  'blog_masonry_title_color' => '',
				  'blog_masonry_title_hover_color' => '',
				  'blog_masonry_title_fontsize' => '',
				  'blog_masonry_title_lineheight' => '',
				  'blog_masonry_title_texttransform' => '',
				  'blog_masonry_title_google_fonts' => '-1',
				  'blog_masonry_title_fontstyle' => '',
				  'blog_masonry_title_fontweight' => '',
				  'blog_masonry_title_letterspacing' => '',
				  'blog_masonry_post_info_color' => '',
				  'blog_masonry_post_info_link_color' => '',
				  'blog_masonry_post_info_link_hover_color' => '',
				  'blog_masonry_post_info_fontsize' => '',
				  'blog_masonry_post_info_lineheight' => '',
				  'blog_masonry_post_info_texttransform' => '',
				  'blog_masonry_post_info_google_fonts' => '-1',
				  'blog_masonry_post_info_fontstyle' => '',
				  'blog_masonry_post_info_fontweight' => '',
				  'blog_masonry_post_info_letterspacing' => '',
				  'blog_masonry_ql_post_info_color' => '',
				  'blog_masonry_ql_post_info_link_color' => '',
				  'blog_masonry_ql_post_info_link_hover_color' => '',
				  'blog_masonry_ql_post_info_fontsize' => '',
				  'blog_masonry_ql_post_info_lineheight' => '',
				  'blog_masonry_ql_post_info_texttransform' => '',
				  'blog_masonry_ql_post_info_google_fonts' => '-1',
				  'blog_masonry_ql_post_info_fontstyle' => '',
				  'blog_masonry_ql_post_info_fontweight' => '',
				  'blog_masonry_ql_post_info_letterspacing' => '',
				  'blog_masonry_gallery_title_color' => '',
				  'blog_masonry_gallery_title_hover_color' => '',
				  'blog_masonry_gallery_title_fontsize' => '',
				  'blog_masonry_gallery_title_lineheight' => '',
				  'blog_masonry_gallery_title_texttransform' => '',
				  'blog_masonry_gallery_title_google_fonts' => '-1',
				  'blog_masonry_gallery_title_fontstyle' => '',
				  'blog_masonry_gallery_title_fontweight' => '',
				  'blog_masonry_gallery_title_letterspacing' => '',
				  'blog_masonry_gallery_post_info_color' => '',
				  'blog_masonry_gallery_post_info_link_color' => '',
				  'blog_masonry_gallery_post_info_link_hover_color' => '',
				  'blog_masonry_gallery_post_info_fontsize' => '',
				  'blog_masonry_gallery_post_info_lineheight' => '',
				  'blog_masonry_gallery_post_info_texttransform' => '',
				  'blog_masonry_gallery_post_info_google_fonts' => '-1',
				  'blog_masonry_gallery_post_info_fontstyle' => '',
				  'blog_masonry_gallery_post_info_fontweight' => '',
				  'blog_masonry_gallery_post_info_letterspacing' => '',
				  'blog_masonry_gallery_ql_post_info_color' => '',
				  'blog_masonry_gallery_ql_post_info_fontsize' => '',
				  'blog_masonry_gallery_ql_post_info_lineheight' => '',
				  'blog_masonry_gallery_ql_post_info_texttransform' => '',
				  'blog_masonry_gallery_ql_post_info_google_fonts' => '-1',
				  'blog_masonry_gallery_ql_post_info_fontstyle' => '',
				  'blog_masonry_gallery_ql_post_info_fontweight' => '',
				  'blog_masonry_gallery_ql_post_info_letterspacing' => '',
				  'blog_gallery_title_color' => '',
				  'blog_gallery_title_hover_color' => '',
				  'blog_gallery_title_fontsize' => '',
				  'blog_gallery_title_lineheight' => '',
				  'blog_gallery_title_texttransform' => '',
				  'blog_gallery_title_google_fonts' => '-1',
				  'blog_gallery_title_fontstyle' => '',
				  'blog_gallery_title_fontweight' => '',
				  'blog_gallery_title_letterspacing' => '',
				  'blog_gallery_post_info_color' => '',
				  'blog_gallery_post_info_link_color' => '',
				  'blog_gallery_post_info_link_hover_color' => '',
				  'blog_gallery_post_info_fontsize' => '',
				  'blog_gallery_post_info_lineheight' => '',
				  'blog_gallery_post_info_texttransform' => '',
				  'blog_gallery_post_info_google_fonts' => '-1',
				  'blog_gallery_post_info_fontstyle' => '',
				  'blog_gallery_post_info_fontweight' => '',
				  'blog_gallery_post_info_letterspacing' => '',
				  'blog_chequered_title_color' => '',
				  'blog_chequered_title_hover_color' => '',
				  'blog_chequered_title_fontsize' => '',
				  'blog_chequered_title_lineheight' => '',
				  'blog_chequered_title_texttransform' => '',
				  'blog_chequered_title_google_fonts' => '-1',
				  'blog_chequered_title_fontstyle' => '',
				  'blog_chequered_title_fontweight' => '',
				  'blog_chequered_title_letterspacing' => '',
				  'blog_chequered_post_info_color' => '',
				  'blog_chequered_post_info_link_color' => '',
				  'blog_chequered_post_info_link_hover_color' => '',
				  'blog_chequered_post_info_fontsize' => '',
				  'blog_chequered_post_info_lineheight' => '',
				  'blog_chequered_post_info_texttransform' => '',
				  'blog_chequered_post_info_google_fonts' => '-1',
				  'blog_chequered_post_info_fontstyle' => '',
				  'blog_chequered_post_info_fontweight' => '',
				  'blog_chequered_post_info_letterspacing' => '',
				  'blog_chequered_ql_post_info_color' => '',
				  'blog_chequered_ql_post_info_fontsize' => '',
				  'blog_chequered_ql_post_info_lineheight' => '',
				  'blog_chequered_ql_post_info_texttransform' => '',
				  'blog_chequered_ql_post_info_google_fonts' => '-1',
				  'blog_chequered_ql_post_info_fontstyle' => '',
				  'blog_chequered_ql_post_info_fontweight' => '',
				  'blog_chequered_ql_post_info_letterspacing' => '',
				  'blog_large_image_simple_side_padding_left' => '',
				  'blog_large_image_simple_side_padding_right' => '',
				  'blog_large_image_simple_title_color' => '',
				  'blog_large_image_simple_title_hover_color' => '',
				  'blog_large_image_simple_title_fontsize' => '',
				  'blog_large_image_simple_title_lineheight' => '',
				  'blog_large_image_simple_title_texttransform' => '',
				  'blog_large_image_simple_title_google_fonts' => '-1',
				  'blog_large_image_simple_title_fontstyle' => '',
				  'blog_large_image_simple_title_fontweight' => '',
				  'blog_large_image_simple_title_letterspacing' => '',
				  'blog_large_image_simple_post_info_color' => '',
				  'blog_large_image_simple_post_info_fontsize' => '',
				  'blog_large_image_simple_post_info_lineheight' => '',
				  'blog_large_image_simple_post_info_texttransform' => '',
				  'blog_large_image_simple_post_info_google_fonts' => '-1',
				  'blog_large_image_simple_post_info_fontstyle' => '',
				  'blog_large_image_simple_post_info_fontweight' => '',
				  'blog_large_image_simple_post_info_letterspacing' => '',
				  'blog_large_image_simple_ql_post_info_color' => '',
				  'blog_large_image_simple_ql_post_info_fontsize' => '',
				  'blog_large_image_simple_ql_post_info_lineheight' => '',
				  'blog_large_image_simple_ql_post_info_texttransform' => '',
				  'blog_large_image_simple_ql_post_info_google_fonts' => '-1',
				  'blog_large_image_simple_ql_post_info_fontstyle' => '',
				  'blog_large_image_simple_ql_post_info_fontweight' => '',
				  'blog_large_image_simple_ql_post_info_letterspacing' => '',
				  'blog_large_image_dividers_background_color' => '',
				  'blog_large_image_dividers_title_color' => '',
				  'blog_large_image_dividers_title_hover_color' => '',
				  'blog_large_image_dividers_title_fontsize' => '',
				  'blog_large_image_dividers_title_lineheight' => '',
				  'blog_large_image_dividers_title_texttransform' => '',
				  'blog_large_image_dividers_title_google_fonts' => '-1',
				  'blog_large_image_dividers_title_fontstyle' => '',
				  'blog_large_image_dividers_title_fontweight' => '',
				  'blog_large_image_dividers_title_letterspacing' => '',
				  'blog_large_image_dividers_post_info_color' => '',
				  'blog_large_image_dividers_post_info_link_color' => '',
				  'blog_large_image_dividers_post_info_link_hover_color' => '',
				  'blog_large_image_dividers_post_info_fontsize' => '',
				  'blog_large_image_dividers_post_info_lineheight' => '',
				  'blog_large_image_dividers_post_info_texttransform' => '',
				  'blog_large_image_dividers_post_info_google_fonts' => '-1',
				  'blog_large_image_dividers_post_info_fontstyle' => '',
				  'blog_large_image_dividers_post_info_fontweight' => '',
				  'blog_large_image_dividers_post_info_letterspacing' => '',
				  'blog_large_image_dividers_ql_post_info_color' => '',
				  'blog_large_image_dividers_ql_post_info_link_color' => '',
				  'blog_large_image_dividers_ql_post_info_link_hover_color' => '',
				  'blog_large_image_dividers_ql_post_info_fontsize' => '',
				  'blog_large_image_dividers_ql_post_info_lineheight' => '',
				  'blog_large_image_dividers_ql_post_info_texttransform' => '',
				  'blog_large_image_dividers_ql_post_info_google_fonts' => '-1',
				  'blog_large_image_dividers_ql_post_info_fontstyle' => '',
				  'blog_large_image_dividers_ql_post_info_fontweight' => '',
				  'blog_large_image_dividers_ql_post_info_letterspacing' => '',
				  'blog_vertical_loop_title_color' => '',
				  'blog_vertical_loop_title_hover_color' => '',
				  'blog_vertical_loop_title_fontsize' => '',
				  'blog_vertical_loop_title_lineheight' => '',
				  'blog_vertical_loop_title_texttransform' => '',
				  'blog_vertical_loop_title_google_fonts' => '-1',
				  'blog_vertical_loop_title_fontstyle' => '',
				  'blog_vertical_loop_title_fontweight' => '',
				  'blog_vertical_loop_title_letterspacing' => '',
				  'blog_vertical_loop_next_post_title_color' => '',
				  'blog_vertical_loop_next_post_title_fontsize' => '',
				  'blog_vertical_loop_next_post_title_lineheight' => '',
				  'blog_vertical_loop_next_post_title_texttransform' => '',
				  'blog_vertical_loop_next_post_title_google_fonts' => '-1',
				  'blog_vertical_loop_next_post_title_fontstyle' => '',
				  'blog_vertical_loop_next_post_title_fontweight' => '',
				  'blog_vertical_loop_next_post_title_letterspacing' => '',
				  'blog_vertical_loop_post_info_color' => '',
				  'blog_vertical_loop_post_info_link_color' => '',
				  'blog_vertical_loop_post_info_hover_color' => '',
				  'blog_vertical_loop_post_info_fontsize' => '',
				  'blog_vertical_loop_post_info_lineheight' => '',
				  'blog_vertical_loop_post_info_texttransform' => '',
				  'blog_vertical_loop_post_info_google_fonts' => '-1',
				  'blog_vertical_loop_post_info_fontstyle' => '',
				  'blog_vertical_loop_post_info_fontweight' => '',
				  'blog_vertical_loop_post_info_letterspacing' => '',
				  'blog_vertical_loop_ql_title_color' => '',
				  'blog_vertical_loop_ql_title_hover_color' => '',
				  'blog_vertical_loop_ql_title_author_color' => '',
				  'blog_vertical_loop_ql_title_fontsize' => '',
				  'blog_vertical_loop_ql_title_lineheight' => '',
				  'blog_vertical_loop_ql_title_texttransform' => '',
				  'blog_vertical_loop_ql_title_google_fonts' => '-1',
				  'blog_vertical_loop_ql_title_fontstyle' => '',
				  'blog_vertical_loop_ql_title_fontweight' => '',
				  'blog_vertical_loop_ql_title_letterspacing' => '',
				  'blog_vertical_loop_ql_post_info_color' => '',
				  'blog_vertical_loop_ql_post_info_link_color' => '',
				  'blog_vertical_loop_ql_post_info_hover_color' => '',
				  'blog_vertical_loop_ql_post_info_fontsize' => '',
				  'blog_vertical_loop_ql_post_info_lineheight' => '',
				  'blog_vertical_loop_ql_post_info_texttransform' => '',
				  'blog_vertical_loop_ql_post_info_google_fonts' => '-1',
				  'blog_vertical_loop_ql_post_info_fontstyle' => '',
				  'blog_vertical_loop_ql_post_info_fontweight' => '',
				  'blog_vertical_loop_ql_post_info_letterspacing' => '',
				  'blog_vertical_loop_npb_background_color' => '',
				  'blog_vertical_loop_npb_background_hover_color' => '',
				  'blog_vertical_loop_npb_icon_color' => '',
				  'blog_vertical_loop_npb_icon_hover_color' => '',
				  'blog_masonry_date_image_background_color' => '',
				  'blog_masonry_date_image_title_color' => '',
				  'blog_masonry_date_image_title_hover_color' => '',
				  'blog_masonry_date_image_title_fontsize' => '',
				  'blog_masonry_date_image_title_lineheight' => '',
				  'blog_masonry_date_image_title_texttransform' => '',
				  'blog_masonry_date_image_title_google_fonts' => '-1',
				  'blog_masonry_date_image_title_fontstyle' => '',
				  'blog_masonry_date_image_title_fontweight' => '',
				  'blog_masonry_date_image_title_letterspacing' => '',
				  'blog_masonry_date_image_hover_type' => '',
				  'blog_pinterest_background_color' => '',
				  'blog_pinterest_title_color' => '',
				  'blog_pinterest_title_hover_color' => '',
				  'blog_pinterest_title_fontsize' => '',
				  'blog_pinterest_title_lineheight' => '',
				  'blog_pinterest_title_texttransform' => '',
				  'blog_pinterest_title_google_fonts' => '-1',
				  'blog_pinterest_title_fontstyle' => '',
				  'blog_pinterest_title_fontweight' => '',
				  'blog_pinterest_title_letterspacing' => '',
				  'blog_pinterest_post_info_color' => '',
				  'blog_pinterest_post_info_link_color' => '',
				  'blog_pinterest_post_info_link_hover_color' => '',
				  'blog_pinterest_post_info_fontsize' => '',
				  'blog_pinterest_post_info_lineheight' => '',
				  'blog_pinterest_post_info_texttransform' => '',
				  'blog_pinterest_post_info_google_fonts' => '-1',
				  'blog_pinterest_post_info_fontstyle' => '',
				  'blog_pinterest_post_info_fontweight' => '',
				  'blog_pinterest_post_info_letterspacing' => '',
				  'blog_pinterest_ql_post_info_color' => '',
				  'blog_pinterest_ql_post_info_fontsize' => '',
				  'blog_pinterest_ql_post_info_lineheight' => '',
				  'blog_pinterest_ql_post_info_texttransform' => '',
				  'blog_pinterest_ql_post_info_google_fonts' => '-1',
				  'blog_pinterest_ql_post_info_fontstyle' => '',
				  'blog_pinterest_ql_post_info_fontweight' => '',
				  'blog_pinterest_ql_post_info_letterspacing' => '',
				  'blog_single_type' => 'standard',
				  'blog_imt_post_separator' => 'no',
				  'blog_imt_post_separator_gradient' => 'no',
				  'show_image_on_audio_post' => 'no',
				  'blog_single_sidebar' => 'default',
				  'blog_single_sidebar_custom_display' => '',
				  'blog_share_like_layout' => 'in_post_info',
				  'blog_author_info' => 'no',
				  'blog_single_image_margin_bottom' => '',
				  'blog_single_title_margin_bottom' => '',
				  'blog_single_post_info_margin_bottom' => '',
				  'blog_quote_link_box_color' => '',
				  'blog_slider_title_color' => '',
				  'blog_slider_title_hover_color' => '',
				  'blog_slider_title_fontsize' => '',
				  'blog_slider_title_lineheight' => '',
				  'blog_slider_title_texttransform' => '',
				  'blog_slider_title_google_fonts' => '-1',
				  'blog_slider_title_fontstyle' => '',
				  'blog_slider_title_fontweight' => '',
				  'blog_slider_title_letterspacing' => '',
				  'blog_slider_post_info_color' => '',
				  'blog_slider_post_info_link_color' => '',
				  'blog_slider_post_info_link_hover_color' => '',
				  'blog_slider_post_info_fontsize' => '',
				  'blog_slider_post_info_lineheight' => '',
				  'blog_slider_post_info_texttransform' => '',
				  'blog_slider_post_info_google_fonts' => '-1',
				  'blog_slider_post_info_fontstyle' => '',
				  'blog_slider_post_info_fontweight' => '',
				  'blog_slider_post_info_letterspacing' => '',
				  'blog_slider_day_color' => '',
				  'blog_slider_day_fontsize' => '',
				  'blog_slider_day_lineheight' => '',
				  'blog_slider_day_texttransform' => '',
				  'blog_slider_day_google_fonts' => '-1',
				  'blog_slider_day_fontstyle' => '',
				  'blog_slider_day_fontweight' => '',
				  'blog_slider_day_letterspacing' => '',
				  'blog_slider_title_bottom_margin' => '',
				  'blog_slider_date_bottom_margin' => '',
				  'blog_slider_day_margin' => '',
				  'blog_slsimple_title_color' => '',
				  'blog_slsimple_title_hover_color' => '',
				  'blog_slsimple_title_fontsize' => '',
				  'blog_slsimple_title_lineheight' => '',
				  'blog_slsimple_title_texttransform' => '',
				  'blog_slsimple_title_google_fonts' => '-1',
				  'blog_slsimple_title_fontstyle' => '',
				  'blog_slsimple_title_fontweight' => '',
				  'blog_slsimple_title_letterspacing' => '',
				  'blog_slsimple_post_info_color' => '',
				  'blog_slsimple_post_info_link_color' => '',
				  'blog_slsimple_post_info_link_hover_color' => '',
				  'blog_slsimple_post_info_fontsize' => '',
				  'blog_slsimple_post_info_lineheight' => '',
				  'blog_slsimple_post_info_texttransform' => '',
				  'blog_slsimple_post_info_google_fonts' => '-1',
				  'blog_slsimple_post_info_fontstyle' => '',
				  'blog_slsimple_post_info_fontweight' => '',
				  'blog_slsimple_post_info_letterspacing' => '',
				  'blog_slsimple_title_bottom_margin' => '',
				  'blog_slsimple_post_info_bottom_margin' => '',
				  'blog_slsimple_excerpt_bottom_margin' => '',
				  'blog_slider_box_background_color' => '',
				  'blog_slider_box_background_opacity' => '',
				  'blog_slider_box_border_color' => '',
				  'blog_slider_box_border_opacity' => '',
				  'blog_slider_box_padding_top' => '',
				  'blog_slider_box_padding_right' => '',
				  'blog_slider_box_padding_bottom' => '',
				  'blog_slider_box_padding_left' => '',
				  'blog_slider_box_width' => '',
				  'pagination_border_color' => '',
				  'pagination_number_color' => '',
				  'pagination_hover_background_color' => '',
				  'pagination_hover_number_color' => '',
				  'pagination_width' => '',
				  'pagination_height' => '',
				  'pagination_border_radius' => '',
				  'pagination_border_width' => '',
				  'pagination_font_size' => '',
				  'pagination_space' => '',
				  'portfolio_style' => '1',
				  'portfolio_qode_like' => 'on',
				  'lightbox_single_project' => 'yes',
				  'lightbox_video_single_project' => 'no',
				  'portfolio_columns_number' => '2',
				  'portfolio_single_sidebar' => 'default',
				  'portfolio_single_sidebar_custom_display' => '',
				  'portfolio_single_slug' => '',
				  'disable_portfolio_single_title_label' => 'no',
				  'portfolio_text_follow' => 'portfolio_single_follow',
				  'enable_portfolio_comments' => 'no',
				  'enable_portfolio_related' => 'no',
				  'portfolio_related_image_size' => '',
				  'enable_navigation_title' => 'no',
				  'portfolio_navigation_through_same_category' => 'no',
				  'portfolio_list_overlay_color' => '',
				  'portfolio_list_overlay_opacity' => '',
				  'portfolio_list_standard_title_color' => '',
				  'portfolio_list_standard_title_hover_color' => '',
				  'portfolio_list_standard_title_fontsize' => '',
				  'portfolio_list_standard_title_lineheight' => '',
				  'portfolio_list_standard_title_texttransform' => '',
				  'portfolio_list_standard_title_google_fonts' => '-1',
				  'portfolio_list_standard_title_fontstyle' => '',
				  'portfolio_list_standard_title_fontweight' => '',
				  'portfolio_list_standard_title_letterspacing' => '',
				  'portfolio_list_standard_category_color' => '',
				  'portfolio_list_standard_category_fontsize' => '',
				  'portfolio_list_standard_category_lineheight' => '',
				  'portfolio_list_standard_category_texttransform' => '',
				  'portfolio_list_standard_category_google_fonts' => '-1',
				  'portfolio_list_standard_category_fontstyle' => '',
				  'portfolio_list_standard_category_fontweight' => '',
				  'portfolio_list_standard_category_letterspacing' => '',
				  'portfolio_list_gallery_title_color' => '',
				  'portfolio_list_gallery_title_hover_color' => '',
				  'portfolio_list_gallery_title_fontsize' => '',
				  'portfolio_list_gallery_title_lineheight' => '',
				  'portfolio_list_gallery_title_texttransform' => '',
				  'portfolio_list_gallery_title_google_fonts' => '-1',
				  'portfolio_list_gallery_title_fontstyle' => '',
				  'portfolio_list_gallery_title_fontweight' => '',
				  'portfolio_list_gallery_title_letterspacing' => '',
				  'portfolio_list_gallery_category_color' => '',
				  'portfolio_list_gallery_category_fontsize' => '',
				  'portfolio_list_gallery_category_lineheight' => '',
				  'portfolio_list_gallery_category_texttransform' => '',
				  'portfolio_list_gallery_category_google_fonts' => '-1',
				  'portfolio_list_gallery_category_fontstyle' => '',
				  'portfolio_list_gallery_category_fontweight' => '',
				  'portfolio_list_gallery_category_letterspacing' => '',
				  'portfolio_list_filter_background_color' => '',
				  'portfolio_list_filter_height' => '',
				  'portfolio_filter_margin_bottom' => '',
				  'thin_icon_only_font_family' => '',
				  'vss_navigation_inactive_color' => '',
				  'vss_navigation_inactive_border_color' => '',
				  'vss_navigation_color' => '',
				  'vss_navigation_border_color' => '',
				  'vss_navigation_size' => '',
				  'vss_left_panel_size' => '',
				  'vss_right_panel_size' => '',
				  'vss_responsive_advanced' => 'no',
				  'vss_responsive_advanced_width' => '768',
				  'enable_social_share' => 'no',
				  'post_types_names_post' => '',
				  'post_types_names_page' => '',
				  'post_types_names_attachment' => '',
				  'post_types_names_portfolio_page' => '',
				  'enable_facebook_share' => 'no',
				  'facebook_icon' => '',
				  'enable_twitter_share' => 'no',
				  'twitter_icon' => '',
				  'twitter_via' => '',
				  'enable_google_plus' => 'no',
				  'google_plus_icon' => '',
				  'enable_linkedin' => 'no',
				  'linkedin_icon' => '',
				  'enable_tumblr' => 'no',
				  'tumblr_icon' => '',
				  'enable_pinterest' => 'no',
				  'pinterest_icon' => '',
				  'enable_vk' => 'no',
				  'vk_icon' => '',
				  '404_title' => '',
				  '404_subtitle' => '',
				  '404_text' => '',
				  '404_backlabel' => '',
				  'enable_google_map' => 'no',
				  'section_between_map_form' => 'yes',
				  'enable_contact_form' => 'no',
				  'google_maps_address' => '',
				  'google_maps_address2' => '',
				  'google_maps_address3' => '',
				  'google_maps_address4' => '',
				  'google_maps_address5' => '',
				  'google_maps_pin_image' => 'http://test.test/wp-content/themes/bridge/img/pin.png',
				  'google_maps_height' => '750',
				  'google_maps_zoom' => '12',
				  'google_maps_scroll_wheel' => 'no',
				  'google_maps_style' => 'yes',
				  'google_maps_color' => '',
				  'google_maps_saturation' => '',
				  'google_maps_lightness' => '',
				  'section_between_map_form_position' => '',
				  'contact_section_above_form_title' => '',
				  'contact_section_above_form_subtitle' => '',
				  'receive_mail' => '',
				  'email_from' => '',
				  'email_subject' => '',
				  'hide_contact_form_website' => 'no',
				  'contact_heading_above' => '',
				  'use_recaptcha' => 'no',
				  'recaptcha_public_key' => '',
				  'recaptcha_private_key' => '',
				  'enable_contact_page_acceptance' => 'no',
				  'qode_contact_page_acceptance_text' => '',
				  'parallax_onoff' => 'on',
				  'parallax_minheight' => '400',
				  'enable_content_bottom_area' => 'no',
				  'content_bottom_sidebar_custom_display' => '',
				  'content_bottom_in_grid' => 'yes',
				  'content_bottom_background_color' => '',
				  'qode_maintenance_mode' => 'no',
				  'qode_maintenance_page' => '',
				  'reset_to_defaults' => 'no',
			);
		}
	}

	add_action( 'after_setup_theme', 'bridge_qode_init_global_option' );
}